/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.http;

import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.InactivityMonitor;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFactory;
import com.bes.mq.transport.TransportLoggerFactory;
import com.bes.mq.transport.TransportServer;
import com.bes.mq.transport.http.HttpClientTransport;
import com.bes.mq.transport.http.HttpTransportServer;
import com.bes.mq.transport.util.TextProtocolFormat;
import com.bes.mq.transport.xstream.XStreamProtocolFormat;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.URISupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class HttpTransportFactory
extends TransportFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpTransportFactory.class);

    @Override
    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParameters(location));
            HttpTransportServer result = new HttpTransportServer(location, this);
            Map<String, Object> transportOptions = IntrospectionSupport.extractProperties(options, "transport.");
            result.setTransportOption(transportOptions);
            return result;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    protected TextProtocolFormat asTextProtocolFormat(ProtocolFormat protocolFormat) {
        if (protocolFormat instanceof TextProtocolFormat) {
            return (TextProtocolFormat)protocolFormat;
        }
        LOG.trace("Not created with a TextProtocolFormat: " + protocolFormat);
        return new XStreamProtocolFormat();
    }

    @Override
    protected String getDefaultProtocolFormatType() {
        return "xstream";
    }

    @Override
    protected Transport createTransport(URI location, ProtocolFormat wf) throws IOException {
        URI uri;
        TextProtocolFormat textProtocolFormat = this.asTextProtocolFormat(wf);
        try {
            uri = URISupport.removeQuery(location);
        }
        catch (URISyntaxException e) {
            MalformedURLException cause = new MalformedURLException("Error removing query on " + location);
            cause.initCause(e);
            throw cause;
        }
        return new HttpClientTransport(textProtocolFormat, uri);
    }

    @Override
    public Transport serverConfigure(Transport transport, ProtocolFormat format, HashMap options) throws Exception {
        return this.compositeConfigure(transport, format, options);
    }

    @Override
    public Transport compositeConfigure(Transport transport, ProtocolFormat format, Map options) {
        boolean useInactivityMonitor;
        HttpClientTransport httpTransport = (transport = super.compositeConfigure(transport, format, options)).narrow(HttpClientTransport.class);
        if (httpTransport != null && httpTransport.isTrace()) {
            try {
                transport = TransportLoggerFactory.getInstance().createTransportLogger(transport);
            }
            catch (Throwable e) {
                LOG.error("Could not create TransportLogger object for: " + TransportLoggerFactory.defaultLogWriterName + ", reason: " + e, e);
            }
        }
        if (useInactivityMonitor = "true".equals(this.getOption(options, "useInactivityMonitor", "true"))) {
            transport = new InactivityMonitor(transport, null);
            IntrospectionSupport.setProperties(transport, options);
        }
        return transport;
    }
}

