/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.http;

import com.bes.mq.command.BrokerInfo;
import com.bes.mq.transport.SocketConnectorFactory;
import com.bes.mq.transport.WebTransportServerSupport;
import com.bes.mq.transport.http.HttpTransportFactory;
import com.bes.mq.transport.http.HttpTunnelServlet;
import com.bes.mq.transport.util.TextProtocolFormat;
import com.bes.mq.transport.xstream.XStreamProtocolFormat;
import com.bes.mq.util.ServiceStopper;
import com.bes.mq.web.MessageServlet;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class HttpTransportServer
extends WebTransportServerSupport {
    private TextProtocolFormat protocolFormat;
    private HttpTransportFactory transportFactory;

    public HttpTransportServer(URI uri, HttpTransportFactory factory) {
        super(uri);
        this.bindAddress = uri;
        this.transportFactory = factory;
        this.socketConnectorFactory = new SocketConnectorFactory();
    }

    @Override
    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }

    public TextProtocolFormat getProtocolFormat() {
        if (this.protocolFormat == null) {
            this.protocolFormat = this.createProtocolFormat();
        }
        return this.protocolFormat;
    }

    public void setProtocolFormat(TextProtocolFormat protocolFormat) {
        this.protocolFormat = protocolFormat;
    }

    protected TextProtocolFormat createProtocolFormat() {
        return new XStreamProtocolFormat();
    }

    protected void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Override
    protected void doStart() throws Exception {
        this.server = new Server();
        QueuedThreadPool queuedThreadPool = new QueuedThreadPool();
        queuedThreadPool.setMaxThreads(Integer.MAX_VALUE);
        this.server.setThreadPool((ThreadPool)queuedThreadPool);
        if (this.connector == null) {
            this.connector = this.socketConnectorFactory.createConnector();
        }
        URI bind = this.getBindLocation();
        this.bind();
        ServletContextHandler contextHandler = new ServletContextHandler((HandlerContainer)this.server, "/", 0);
        contextHandler.setInitParameter("com.bes.mq.connectionFactory.prefetch", "1");
        if (this.getConnector().isEnableJms()) {
            ServletHolder holder = new ServletHolder();
            holder.setServlet((Servlet)new HttpTunnelServlet());
            contextHandler.addServlet(holder, "/");
        }
        if (this.getConnector().getRestService() != null && this.getConnector().getRestService().isEnableRest()) {
            ServletHolder servlet = new ServletHolder();
            servlet.setServlet((Servlet)new MessageServlet());
            servlet.setInitParameter("defaultContentType", this.getConnector().getRestService().getDefaultContextType());
            servlet.setInitParameter("defaultReadTimeout", this.getConnector().getRestService().getDefaultReadTimeout());
            servlet.setInitParameter("maximumReadTimeout", this.getConnector().getRestService().getMaximumReadTimeout());
            servlet.getRegistration().setLoadOnStartup(1);
            contextHandler.addServlet(servlet, this.getConnector().getRestService().getContext() + "/*");
        }
        contextHandler.setAttribute("acceptListener", (Object)this.getAcceptListener());
        contextHandler.setAttribute("protocolFormat", (Object)this.getProtocolFormat());
        contextHandler.setAttribute("transportFactory", (Object)this.transportFactory);
        contextHandler.setAttribute("transportOptions", (Object)this.transportOptions);
        GzipHandler gzipHandler = new GzipHandler();
        contextHandler.setHandler((Handler)gzipHandler);
        this.server.start();
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        Server temp = this.server;
        this.server = null;
        if (temp != null) {
            temp.stop();
        }
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return null;
    }

    @Override
    public void setTransportOption(Map<String, Object> transportOptions) {
        this.socketConnectorFactory.setTransportOptions(transportOptions);
        super.setTransportOption(transportOptions);
    }
}

