/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.https;

import com.bes.mq.broker.SslContext;
import com.bes.mq.org.apache.http.conn.ClientConnectionManager;
import com.bes.mq.org.apache.http.conn.scheme.Scheme;
import com.bes.mq.org.apache.http.conn.scheme.SchemeRegistry;
import com.bes.mq.org.apache.http.impl.conn.PoolingClientConnectionManager;
import com.bes.mq.transport.http.HttpClientTransport;
import com.bes.mq.transport.util.TextProtocolFormat;
import java.net.URI;
import javax.net.ssl.SSLSocketFactory;

public class HttpsClientTransport
extends HttpClientTransport {
    private SslContext context;

    public HttpsClientTransport(TextProtocolFormat protocolFormat, URI remoteUrl) {
        super(protocolFormat, remoteUrl);
    }

    @Override
    protected ClientConnectionManager createClientConnectionManager() {
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(this.createSchemeRegistry());
        return connectionManager;
    }

    private SchemeRegistry createSchemeRegistry() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        try {
            com.bes.mq.org.apache.http.conn.ssl.SSLSocketFactory sslSocketFactory = this.context != null ? new com.bes.mq.org.apache.http.conn.ssl.SSLSocketFactory(this.context.getSSLContext(), com.bes.mq.org.apache.http.conn.ssl.SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER) : new com.bes.mq.org.apache.http.conn.ssl.SSLSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), com.bes.mq.org.apache.http.conn.ssl.SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            schemeRegistry.register(new Scheme("https", this.getRemoteUrl().getPort(), sslSocketFactory));
            return schemeRegistry;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failure trying to create scheme registry", e);
        }
    }

    public void setContext(SslContext context) {
        this.context = context;
    }

    public SslContext getContext() {
        return this.context;
    }
}

