/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.https;

import com.bes.mq.broker.SslContext;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportServer;
import com.bes.mq.transport.http.HttpTransportFactory;
import com.bes.mq.transport.https.HttpsClientTransport;
import com.bes.mq.transport.https.HttpsTransportServer;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.URISupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class HttpsTransportFactory
extends HttpTransportFactory {
    public TransportServer doBind(String brokerId, URI location) throws IOException {
        return this.doBind(location);
    }

    @Override
    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParameters(location));
            HttpsTransportServer result = new HttpsTransportServer(location, this, SslContext.getCurrentSslContext());
            Map<String, Object> transportOptions = IntrospectionSupport.extractProperties(options, "transport.");
            result.setTransportOption(transportOptions);
            return result;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    @Override
    protected Transport createTransport(URI location, ProtocolFormat wf) throws MalformedURLException {
        URI uri;
        try {
            uri = URISupport.removeQuery(location);
            uri = URISupport.changeScheme(uri, "https");
        }
        catch (URISyntaxException e) {
            MalformedURLException cause = new MalformedURLException("Error removing query on " + location);
            cause.initCause(e);
            throw cause;
        }
        HttpsClientTransport transport = new HttpsClientTransport(this.asTextProtocolFormat(wf), uri);
        transport.setContext(SslContext.getCurrentSslContext());
        return transport;
    }
}

