/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.logwriters;

import com.bes.mq.command.BaseCommand;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.command.ProducerAck;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.ProtocolFormatInfo;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.transport.LogWriter;
import java.io.IOException;

public class CustomLogWriter
implements LogWriter {
    public void initialMessage(Logger log) {
    }

    public void logRequest(Logger log, Object command) {
        log.debug("$$ SENDREQ: " + CustomLogWriter.commandToString(command));
    }

    public void logResponse(Logger log, Object response) {
        log.debug("$$ GOT_RESPONSE: " + response);
    }

    public void logAsyncRequest(Logger log, Object command) {
        log.debug("$$ SENDING_ASNYC_REQUEST: " + command);
    }

    public void logOneWay(Logger log, Object command) {
        log.debug("$$ SENDING: " + CustomLogWriter.commandToString(command));
    }

    public void logReceivedCommand(Logger log, Object command) {
        log.debug("$$ RECEIVED: " + CustomLogWriter.commandToString(command));
    }

    public void logReceivedException(Logger log, IOException error) {
        log.debug("$$ RECEIVED_EXCEPTION: " + error, error);
    }

    private static String commandToString(Object command) {
        StringBuilder sb = new StringBuilder();
        if (command instanceof BaseCommand) {
            BaseCommand bc = (BaseCommand)command;
            sb.append(command.getClass().getSimpleName());
            sb.append(' ');
            sb.append(bc.isResponseRequired() ? (char)'T' : 'F');
            Message m = null;
            if (bc instanceof Message) {
                m = (Message)bc;
            }
            if (bc instanceof MessageDispatch) {
                m = ((MessageDispatch)bc).getMessage();
            }
            if (m != null) {
                sb.append(' ');
                sb.append(m.getMessageId());
                sb.append(',');
                sb.append(m.getCommandId());
                ProducerId pid = m.getProducerId();
                long sid = pid.getSessionId();
                sb.append(',');
                sb.append(pid.getConnectionId());
                sb.append(',');
                sb.append(sid);
                sb.append(',');
                sb.append(pid.getValue());
                sb.append(',');
                sb.append(m.getCorrelationId());
                sb.append(',');
                sb.append(m.getType());
            }
            if (bc instanceof MessageDispatch) {
                sb.append(" toConsumer:");
                sb.append(((MessageDispatch)bc).getConsumerId());
            }
            if (bc instanceof ProducerAck) {
                sb.append(" ProducerId:");
                sb.append(((ProducerAck)bc).getProducerId());
            }
            if (bc instanceof MessageAck) {
                MessageAck ma = (MessageAck)bc;
                sb.append(" ConsumerID:");
                sb.append(ma.getConsumerId());
                sb.append(" ack:");
                sb.append(ma.getFirstMessageId());
                sb.append('-');
                sb.append(ma.getLastMessageId());
            }
            if (bc instanceof ConnectionInfo) {
                ConnectionInfo ci = (ConnectionInfo)bc;
                sb.append(' ');
                sb.append(ci.getConnectionId());
            }
        } else if (command instanceof ProtocolFormatInfo) {
            sb.append("ProtocolFormatInfo");
        } else {
            sb.append("Unrecognized_object ");
            sb.append(command.toString());
        }
        return sb.toString();
    }
}

