/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.mock;

import com.bes.mq.transport.MutexTransport;
import com.bes.mq.transport.ResponseCorrelator;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFactory;
import com.bes.mq.transport.TransportServer;
import com.bes.mq.transport.mock.MockTransport;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.URISupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class MockTransportFactory
extends TransportFactory {
    public Transport doConnect(URI location) throws URISyntaxException, Exception {
        Transport transport = this.createTransport(URISupport.parseComposite(location));
        transport = new MutexTransport(transport);
        transport = new ResponseCorrelator(transport);
        return transport;
    }

    public Transport doCompositeConnect(URI location) throws URISyntaxException, Exception {
        return this.createTransport(URISupport.parseComposite(location));
    }

    public Transport createTransport(URISupport.CompositeData compositData) throws Exception {
        MockTransport transport = new MockTransport(TransportFactory.compositeConnect(compositData.getComponents()[0]));
        IntrospectionSupport.setProperties(transport, compositData.getParameters());
        return transport;
    }

    public TransportServer doBind(URI location) throws IOException {
        throw new IOException("This protocol does not support being bound.");
    }
}

