/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.mqtt;

import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.thread.SchedulerTimerTask;
import com.bes.mq.transport.AbstractInactivityMonitor;
import com.bes.mq.transport.InactivityIOException;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFilter;
import com.bes.mq.transport.mqtt.MQTTProtocolConverter;
import com.bes.mq.util.ThreadPoolUtils;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class MQTTInactivityMonitor
extends TransportFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTInactivityMonitor.class);
    private static final long DEFAULT_CHECK_TIME_MILLS = 30000L;
    private static ThreadPoolExecutor ASYNC_TASKS;
    private static int CHECKER_COUNTER;
    private static Timer READ_CHECK_TIMER;
    private final AtomicBoolean monitorStarted = new AtomicBoolean(false);
    private final AtomicBoolean failed = new AtomicBoolean(false);
    private final AtomicBoolean inReceive = new AtomicBoolean(false);
    private final AtomicInteger lastReceiveCounter = new AtomicInteger(0);
    private final ReentrantLock sendLock = new ReentrantLock();
    private SchedulerTimerTask readCheckerTask;
    private long readGraceTime = 30000L;
    private long readKeepAliveTime = 30000L;
    private boolean keepAliveResponseRequired;
    private MQTTProtocolConverter protocolConverter;
    private final Runnable readChecker = new Runnable(){
        long lastReceiveTime = System.currentTimeMillis();

        public void run() {
            long now = System.currentTimeMillis();
            int currentCounter = MQTTInactivityMonitor.this.next.getReceiveCounter();
            int previousCounter = MQTTInactivityMonitor.this.lastReceiveCounter.getAndSet(currentCounter);
            if (MQTTInactivityMonitor.this.inReceive.get() || currentCounter != previousCounter) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Command received since last read check.");
                }
                this.lastReceiveTime = now;
                return;
            }
            if (now - this.lastReceiveTime >= MQTTInactivityMonitor.this.readKeepAliveTime + MQTTInactivityMonitor.this.readGraceTime && MQTTInactivityMonitor.this.monitorStarted.get() && !ASYNC_TASKS.isTerminating()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No message received since last read check for " + MQTTInactivityMonitor.this.toString() + "! Throwing InactivityIOException.");
                }
                ASYNC_TASKS.execute(new Runnable(){

                    public void run() {
                        MQTTInactivityMonitor.this.onException(new InactivityIOException("Channel was inactive for too (>" + (MQTTInactivityMonitor.this.readKeepAliveTime + MQTTInactivityMonitor.this.readGraceTime) + ") long: " + MQTTInactivityMonitor.this.next.getRemoteAddress()));
                    }
                });
            }
        }
    };
    private final ThreadFactory factory = new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "MQTTInactivityMonitor Async Task: " + runnable);
            thread.setDaemon(true);
            return thread;
        }
    };

    private boolean allowReadCheck(long elapsed) {
        return elapsed > this.readGraceTime * 9L / 10L;
    }

    public MQTTInactivityMonitor(Transport next, ProtocolFormat protocolFormat) {
        super(next);
    }

    public void start() throws Exception {
        this.next.start();
        this.startMonitorThread();
    }

    public void stop() throws Exception {
        this.stopMonitorThread();
        this.next.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommand(Object command) {
        this.inReceive.set(true);
        try {
            this.transportListener.onCommand(command);
        }
        finally {
            this.inReceive.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oneway(Object o) throws IOException {
        this.sendLock.lock();
        try {
            this.doOnewaySend(o);
        }
        finally {
            this.sendLock.unlock();
        }
    }

    private void doOnewaySend(Object command) throws IOException {
        if (this.failed.get()) {
            throw new InactivityIOException("Cannot send, channel has already failed: " + this.next.getRemoteAddress());
        }
        this.next.oneway(command);
    }

    public void onException(IOException error) {
        if (this.failed.compareAndSet(false, true)) {
            this.stopMonitorThread();
            if (this.protocolConverter != null) {
                this.protocolConverter.onTransportError();
            }
            this.transportListener.onException(error);
        }
    }

    public long getReadGraceTime() {
        return this.readGraceTime;
    }

    public void setReadGraceTime(long readGraceTime) {
        this.readGraceTime = readGraceTime;
    }

    public long getReadKeepAliveTime() {
        return this.readKeepAliveTime;
    }

    public void setReadKeepAliveTime(long readKeepAliveTime) {
        this.readKeepAliveTime = readKeepAliveTime;
    }

    public boolean isKeepAliveResponseRequired() {
        return this.keepAliveResponseRequired;
    }

    public void setKeepAliveResponseRequired(boolean value) {
        this.keepAliveResponseRequired = value;
    }

    public boolean isMonitorStarted() {
        return this.monitorStarted.get();
    }

    public void setProtocolConverter(MQTTProtocolConverter protocolConverter) {
        this.protocolConverter = protocolConverter;
    }

    public MQTTProtocolConverter getProtocolConverter() {
        return this.protocolConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void startMonitorThread() {
        if (this.protocolConverter == null) {
            return;
        }
        if (this.monitorStarted.get()) {
            return;
        }
        if (this.readKeepAliveTime > 0L) {
            this.readCheckerTask = new SchedulerTimerTask(this.readChecker);
        }
        if (this.readKeepAliveTime <= 0L) return;
        this.monitorStarted.set(true);
        Class<AbstractInactivityMonitor> clazz = AbstractInactivityMonitor.class;
        synchronized (AbstractInactivityMonitor.class) {
            if (CHECKER_COUNTER == 0) {
                ASYNC_TASKS = this.createExecutor();
                READ_CHECK_TIMER = new Timer("InactivityMonitor ReadCheck", true);
            }
            ++CHECKER_COUNTER;
            if (this.readKeepAliveTime <= 0L) return;
            READ_CHECK_TIMER.schedule((TimerTask)this.readCheckerTask, this.readKeepAliveTime, this.readGraceTime);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void stopMonitorThread() {
        if (!this.monitorStarted.compareAndSet(true, false)) return;
        if (this.readCheckerTask != null) {
            this.readCheckerTask.cancel();
        }
        Class<AbstractInactivityMonitor> clazz = AbstractInactivityMonitor.class;
        synchronized (AbstractInactivityMonitor.class) {
            READ_CHECK_TIMER.purge();
            if (--CHECKER_COUNTER != 0) return;
            READ_CHECK_TIMER.cancel();
            READ_CHECK_TIMER = null;
            ThreadPoolUtils.shutdown(ASYNC_TASKS);
            ASYNC_TASKS = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private ThreadPoolExecutor createExecutor() {
        ThreadPoolExecutor exec = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.factory);
        exec.allowCoreThreadTimeOut(true);
        return exec;
    }
}

