/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.mqtt;

import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.mqtt.MQTTCodec;
import com.bes.mq.transport.nio.NIOSSLTransport;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import javax.net.SocketFactory;
import org.fusesource.hawtbuf.DataByteArrayInputStream;

public class MQTTNIOSSLTransport
extends NIOSSLTransport {
    MQTTCodec codec;

    public MQTTNIOSSLTransport(ProtocolFormat protocolFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        super(protocolFormat, socketFactory, remoteLocation, localLocation);
    }

    public MQTTNIOSSLTransport(ProtocolFormat protocolFormat, Socket socket) throws IOException {
        super(protocolFormat, socket);
    }

    protected void initializeStreams() throws IOException {
        this.codec = new MQTTCodec(this);
        super.initializeStreams();
        if (this.inputBuffer.position() != 0 && this.inputBuffer.hasRemaining()) {
            this.serviceRead();
        }
    }

    protected void processCommand(ByteBuffer plain) throws Exception {
        byte[] fill = new byte[plain.remaining()];
        plain.get(fill);
        DataByteArrayInputStream dis = new DataByteArrayInputStream(fill);
        this.codec.parse(dis, fill.length);
    }
}

