/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.mqtt;

import com.bes.mq.broker.SslContext;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportServer;
import com.bes.mq.transport.mqtt.MQTTNIOSSLTransport;
import com.bes.mq.transport.mqtt.MQTTNIOTransportFactory;
import com.bes.mq.transport.tcp.TcpTransport;
import com.bes.mq.transport.tcp.TcpTransportServer;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;

public class MQTTNIOSSLTransportFactory
extends MQTTNIOTransportFactory {
    SSLContext context;

    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new TcpTransportServer(this, location, serverSocketFactory){

            protected Transport createTransport(Socket socket, ProtocolFormat format) throws IOException {
                MQTTNIOSSLTransport transport = new MQTTNIOSSLTransport(format, socket);
                if (MQTTNIOSSLTransportFactory.this.context != null) {
                    transport.setSslContext(MQTTNIOSSLTransportFactory.this.context);
                }
                return transport;
            }
        };
    }

    protected TcpTransport createTcpTransport(ProtocolFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new MQTTNIOSSLTransport(wf, socketFactory, location, localLocation);
    }

    public TransportServer doBind(URI location) throws IOException {
        if (SslContext.getCurrentSslContext() != null) {
            try {
                this.context = SslContext.getCurrentSslContext().getSSLContext();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return super.doBind(location);
    }
}

