/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.mqtt;

import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.mqtt.MQTTCodec;
import com.bes.mq.transport.nio.NIOOutputStream;
import com.bes.mq.transport.nio.SelectorManager;
import com.bes.mq.transport.nio.SelectorSelection;
import com.bes.mq.transport.tcp.TcpTransport;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.ServiceStopper;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.SocketFactory;
import org.fusesource.hawtbuf.DataByteArrayInputStream;

public class MQTTNIOTransport
extends TcpTransport {
    private SocketChannel channel;
    private SelectorSelection selection;
    private ByteBuffer inputBuffer;
    MQTTCodec codec;

    public MQTTNIOTransport(ProtocolFormat protocolFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        super(protocolFormat, socketFactory, remoteLocation, localLocation);
    }

    public MQTTNIOTransport(ProtocolFormat protocolFormat, Socket socket) throws IOException {
        super(protocolFormat, socket);
    }

    protected void initializeStreams() throws IOException {
        this.channel = this.socket.getChannel();
        this.channel.configureBlocking(false);
        this.selection = SelectorManager.getInstance().register(this.channel, new SelectorManager.Listener(){

            public void onSelect(SelectorSelection selection) {
                if (!MQTTNIOTransport.this.isStopped()) {
                    MQTTNIOTransport.this.serviceRead();
                }
            }

            public void onError(SelectorSelection selection, Throwable error) {
                if (error instanceof IOException) {
                    MQTTNIOTransport.this.onException((IOException)error);
                } else {
                    MQTTNIOTransport.this.onException(IOExceptionSupport.create(error));
                }
            }
        });
        this.inputBuffer = ByteBuffer.allocate(8192);
        NIOOutputStream outPutStream = new NIOOutputStream(this.channel, 8192);
        this.dataOut = new DataOutputStream(outPutStream);
        this.buffOut = outPutStream;
        this.codec = new MQTTCodec(this);
    }

    private void serviceRead() {
        try {
            while (this.isStarted()) {
                int readSize = this.channel.read(this.inputBuffer);
                if (readSize == -1) {
                    this.onException(new EOFException());
                    this.selection.close();
                } else if (readSize != 0) {
                    this.inputBuffer.flip();
                    DataByteArrayInputStream dis = new DataByteArrayInputStream(this.inputBuffer.array());
                    this.codec.parse(dis, readSize);
                    this.receiveCounter += readSize;
                    this.inputBuffer.clear();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (Throwable e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    protected void doStart() throws Exception {
        this.connect();
        this.selection.setInterestOps(1);
        this.selection.enable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop(ServiceStopper stopper) throws Exception {
        try {
            if (this.selection != null) {
                this.selection.close();
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.doStop(stopper);
            throw throwable;
        }
        super.doStop(stopper);
    }
}

