/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.mqtt;

import com.bes.mq.Service;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.mqtt.codec.PUBLISH;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.mqtt.MQTTSubscription;
import com.bes.mq.util.LRUCache;
import com.bes.mq.util.ServiceStopper;
import com.bes.mq.util.ServiceSupport;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MQTTPacketIdGenerator
extends ServiceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTPacketIdGenerator.class);
    private static final Object LOCK = new Object();
    Map<String, PacketIdMaps> clientIdMap = new ConcurrentHashMap<String, PacketIdMaps>();
    private final NonZeroSequenceGenerator messageIdGenerator = new NonZeroSequenceGenerator();

    private MQTTPacketIdGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop(ServiceStopper stopper) throws Exception {
        MQTTPacketIdGenerator mQTTPacketIdGenerator = this;
        synchronized (mQTTPacketIdGenerator) {
            this.clientIdMap = new ConcurrentHashMap<String, PacketIdMaps>();
        }
    }

    protected void doStart() throws Exception {
    }

    public void startClientSession(String clientId) {
        if (!this.clientIdMap.containsKey(clientId)) {
            this.clientIdMap.put(clientId, new PacketIdMaps());
        }
    }

    public boolean stopClientSession(String clientId) {
        return this.clientIdMap.remove(clientId) != null;
    }

    public short setPacketId(String clientId, MQTTSubscription subscription, BESMQMessage message, PUBLISH publish) {
        PacketIdMaps idMaps = this.clientIdMap.get(clientId);
        if (idMaps == null) {
            short id = this.messageIdGenerator.getNextSequenceId();
            publish.messageId(id);
            return id;
        }
        return idMaps.setPacketId(subscription, message, publish);
    }

    public void ackPacketId(String clientId, short packetId) {
        PacketIdMaps idMaps = this.clientIdMap.get(clientId);
        if (idMaps != null) {
            idMaps.ackPacketId(packetId);
        }
    }

    public short getNextSequenceId(String clientId) {
        PacketIdMaps idMaps = this.clientIdMap.get(clientId);
        return idMaps != null ? idMaps.getNextSequenceId() : this.messageIdGenerator.getNextSequenceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQTTPacketIdGenerator getMQTTPacketIdGenerator(BrokerService broker) {
        MQTTPacketIdGenerator result = null;
        if (broker != null) {
            Object object = LOCK;
            synchronized (object) {
                Service[] services = broker.getServices();
                if (services != null) {
                    for (Service service : services) {
                        if (!(service instanceof MQTTPacketIdGenerator)) continue;
                        return (MQTTPacketIdGenerator)service;
                    }
                }
                result = new MQTTPacketIdGenerator();
                broker.addService(result);
                if (broker.isStarted()) {
                    try {
                        result.start();
                    }
                    catch (Exception e) {
                        LOG.warn("Couldn't start MQTTPacketIdGenerator");
                    }
                }
            }
        }
        return result;
    }

    private class NonZeroSequenceGenerator {
        private short lastSequenceId;

        private NonZeroSequenceGenerator() {
        }

        public synchronized short getNextSequenceId() {
            this.lastSequenceId = (short)(this.lastSequenceId + 1);
            short val = this.lastSequenceId;
            return val != 0 ? val : (this.lastSequenceId = (short)(this.lastSequenceId + 1));
        }
    }

    private class PacketIdMaps {
        private final NonZeroSequenceGenerator messageIdGenerator;
        final Map<String, Short> besmqToPacketIds;
        final Map<Short, String> packetIdsToBesmq;

        private PacketIdMaps() {
            this.messageIdGenerator = new NonZeroSequenceGenerator();
            this.besmqToPacketIds = new LRUCache<String, Short>(5000);
            this.packetIdsToBesmq = new LRUCache<Short, String>(5000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        short setPacketId(MQTTSubscription subscription, BESMQMessage message, PUBLISH publish) {
            Short packetId;
            StringBuilder subscriptionKey = new StringBuilder();
            subscriptionKey.append(subscription.getConsumerInfo().getDestination().getPhysicalName()).append(':').append(message.getJMSMessageID());
            String keyStr = subscriptionKey.toString();
            Map<String, Short> map = this.besmqToPacketIds;
            synchronized (map) {
                packetId = this.besmqToPacketIds.get(keyStr);
                if (packetId == null) {
                    packetId = this.getNextSequenceId();
                    this.besmqToPacketIds.put(keyStr, packetId);
                    this.packetIdsToBesmq.put(packetId, keyStr);
                } else {
                    publish.dup(true);
                }
            }
            publish.messageId(packetId.shortValue());
            return packetId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ackPacketId(short packetId) {
            Map<String, Short> map = this.besmqToPacketIds;
            synchronized (map) {
                String subscriptionKey = this.packetIdsToBesmq.remove(packetId);
                if (subscriptionKey != null) {
                    this.besmqToPacketIds.remove(subscriptionKey);
                }
            }
        }

        short getNextSequenceId() {
            return this.messageIdGenerator.getNextSequenceId();
        }
    }
}

