/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.mqtt;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.PrefetchSubscription;
import com.bes.mq.broker.region.RegionBroker;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.TopicRegion;
import com.bes.mq.command.BESMQBytesMessage;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQMapMessage;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.BESMQTextMessage;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.Command;
import com.bes.mq.command.ConnectionError;
import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.ExceptionResponse;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.RemoveInfo;
import com.bes.mq.command.RemoveSubscriptionInfo;
import com.bes.mq.command.Response;
import com.bes.mq.command.SessionId;
import com.bes.mq.command.SessionInfo;
import com.bes.mq.command.ShutdownInfo;
import com.bes.mq.command.SubscriptionInfo;
import com.bes.mq.mqtt.client.QoS;
import com.bes.mq.mqtt.client.Topic;
import com.bes.mq.mqtt.codec.CONNACK;
import com.bes.mq.mqtt.codec.CONNECT;
import com.bes.mq.mqtt.codec.MQTTFrame;
import com.bes.mq.mqtt.codec.PINGRESP;
import com.bes.mq.mqtt.codec.PUBACK;
import com.bes.mq.mqtt.codec.PUBCOMP;
import com.bes.mq.mqtt.codec.PUBLISH;
import com.bes.mq.mqtt.codec.PUBREC;
import com.bes.mq.mqtt.codec.PUBREL;
import com.bes.mq.mqtt.codec.SUBACK;
import com.bes.mq.mqtt.codec.SUBSCRIBE;
import com.bes.mq.mqtt.codec.UNSUBACK;
import com.bes.mq.mqtt.codec.UNSUBSCRIBE;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.PersistenceAdapterSupport;
import com.bes.mq.transport.mqtt.MQTTInactivityMonitor;
import com.bes.mq.transport.mqtt.MQTTPacketIdGenerator;
import com.bes.mq.transport.mqtt.MQTTProtocolException;
import com.bes.mq.transport.mqtt.MQTTSubscription;
import com.bes.mq.transport.mqtt.MQTTTransport;
import com.bes.mq.transport.mqtt.ResponseHandler;
import com.bes.mq.util.ByteArrayOutputStream;
import com.bes.mq.util.ByteSequence;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.IdGenerator;
import com.bes.mq.util.LRUCache;
import com.bes.mq.util.LongSequenceGenerator;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.jms.JMSException;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MQTTProtocolConverter {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTProtocolConverter.class);
    private static final IdGenerator CONNECTION_ID_GENERATOR = new IdGenerator();
    private static final MQTTFrame PING_RESP_FRAME = new PINGRESP().encode();
    private static final double MQTT_KEEP_ALIVE_GRACE_PERIOD = 0.5;
    static final int DEFAULT_CACHE_SIZE = 5000;
    private static final byte SUBSCRIBE_ERROR = -128;
    private final ConnectionId connectionId = new ConnectionId(CONNECTION_ID_GENERATOR.generateId());
    private final SessionId sessionId = new SessionId(this.connectionId, 1L);
    private final LongSequenceGenerator publisherIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    private final ConcurrentHashMap<Integer, ResponseHandler> resposeHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap<ConsumerId, MQTTSubscription> subscriptionsByConsumerId = new ConcurrentHashMap();
    private final ConcurrentHashMap<UTF8Buffer, MQTTSubscription> mqttSubscriptionByTopic = new ConcurrentHashMap();
    private final Map<UTF8Buffer, BESMQTopic> besMQTopicMap = new LRUCache<UTF8Buffer, BESMQTopic>(5000);
    private final Map<javax.jms.Destination, UTF8Buffer> mqttTopicMap = new LRUCache<javax.jms.Destination, UTF8Buffer>(5000);
    private final Set<String> restoredSubs = Collections.synchronizedSet(new HashSet());
    private final Map<Short, MessageAck> consumerAcks = new LRUCache<Short, MessageAck>(5000);
    private final Map<Short, PUBREC> publisherRecs = new LRUCache<Short, PUBREC>(5000);
    private final Map<UTF8Buffer, ProducerInfo> topicProducerInfoMap = new HashMap<UTF8Buffer, ProducerInfo>();
    private final LongSequenceGenerator producerIdGenerator = new LongSequenceGenerator();
    private final MQTTTransport mqttTransport;
    private final BrokerService brokerService;
    private final Object commnadIdMutex = new Object();
    private int lastCommandId;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final ConnectionInfo connectionInfo = new ConnectionInfo();
    private CONNECT connect;
    private String clientId;
    private long defaultKeepAlive;
    private int besMQSubscriptionPrefetch = 1;
    protected static final String QOS_PROPERTY_NAME = "BESMQ.MQTT.QoS";
    private final MQTTPacketIdGenerator packetIdGenerator;
    boolean willSent = false;

    public MQTTProtocolConverter(MQTTTransport mqttTransport, BrokerService brokerService) {
        this.mqttTransport = mqttTransport;
        this.brokerService = brokerService;
        this.packetIdGenerator = MQTTPacketIdGenerator.getMQTTPacketIdGenerator(brokerService);
        this.defaultKeepAlive = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int generateCommandId() {
        Object object = this.commnadIdMutex;
        synchronized (object) {
            return this.lastCommandId++;
        }
    }

    void sendToBESMQ(Command command, ResponseHandler handler) {
        BESMQMessage msg;
        if (command instanceof BESMQMessage && (msg = (BESMQMessage)command).getDestination().getPhysicalName().startsWith("$")) {
            if (handler != null) {
                try {
                    handler.onResponse(this, new Response());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return;
        }
        command.setCommandId(this.generateCommandId());
        if (handler != null) {
            command.setResponseRequired(true);
            this.resposeHandlers.put(command.getCommandId(), handler);
        }
        this.getMQTTTransport().sendToBESMQ(command);
    }

    void sendToMQTT(MQTTFrame frame) {
        try {
            this.mqttTransport.sendToMQTT(frame);
        }
        catch (IOException e) {
            LOG.warn("Failed to send frame " + frame, e);
        }
    }

    public void onMQTTCommand(MQTTFrame frame) throws IOException, JMSException {
        switch (frame.messageType()) {
            case 12: {
                LOG.debug("Received a PING from client: " + this.getClientId());
                this.sendToMQTT(PING_RESP_FRAME);
                LOG.debug("Sent PING response to " + this.getClientId());
                break;
            }
            case 1: {
                CONNECT connect = new CONNECT().decode(frame);
                this.onMQTTConnect(connect);
                LOG.debug("MQTT Client {} connected. (version: {})", (Object)this.getClientId(), (Object)connect.version());
                break;
            }
            case 14: {
                LOG.debug("MQTT Client {} disconnecting", (Object)this.getClientId());
                this.onMQTTDisconnect();
                break;
            }
            case 8: {
                this.onSubscribe(new SUBSCRIBE().decode(frame));
                break;
            }
            case 10: {
                this.onUnSubscribe(new UNSUBSCRIBE().decode(frame));
                break;
            }
            case 3: {
                this.onMQTTPublish(new PUBLISH().decode(frame));
                break;
            }
            case 4: {
                this.onMQTTPubAck(new PUBACK().decode(frame));
                break;
            }
            case 5: {
                this.onMQTTPubRec(new PUBREC().decode(frame));
                break;
            }
            case 6: {
                this.onMQTTPubRel(new PUBREL().decode(frame));
                break;
            }
            case 7: {
                this.onMQTTPubComp(new PUBCOMP().decode(frame));
                break;
            }
            default: {
                this.handleException(new MQTTProtocolException("Unknown MQTTFrame type: " + frame.messageType(), true), frame);
            }
        }
    }

    void onMQTTConnect(final CONNECT connect) throws MQTTProtocolException {
        if (this.connected.get()) {
            throw new MQTTProtocolException("Already connected.");
        }
        this.connect = connect;
        String clientId = "";
        if (connect.clientId() != null) {
            clientId = connect.clientId().toString();
        }
        String userName = null;
        if (connect.userName() != null) {
            userName = connect.userName().toString();
        }
        String passswd = null;
        if (connect.password() != null) {
            passswd = connect.password().toString();
        }
        this.configureInactivityMonitor(connect.keepAlive());
        this.connectionInfo.setConnectionId(this.connectionId);
        if (clientId != null && !clientId.isEmpty()) {
            this.connectionInfo.setClientId(clientId);
        } else {
            if (!connect.cleanSession()) {
                CONNACK ack = new CONNACK();
                ack.code(CONNACK.Code.CONNECTION_REFUSED_IDENTIFIER_REJECTED);
                try {
                    this.getMQTTTransport().sendToMQTT(ack.encode());
                    this.getMQTTTransport().onException(IOExceptionSupport.create("Invalid Client ID", null));
                }
                catch (IOException e) {
                    this.getMQTTTransport().onException(IOExceptionSupport.create(e));
                }
                return;
            }
            this.connectionInfo.setClientId("" + this.connectionInfo.getConnectionId().toString());
        }
        this.connectionInfo.setResponseRequired(true);
        this.connectionInfo.setUserName(userName);
        this.connectionInfo.setPassword(passswd);
        this.connectionInfo.setTransportContext(this.mqttTransport.getPeerCertificates());
        this.sendToBESMQ(this.connectionInfo, new ResponseHandler(){

            public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                if (response.isException()) {
                    Throwable exception = ((ExceptionResponse)response).getException();
                    CONNACK ack = new CONNACK();
                    ack.code(CONNACK.Code.CONNECTION_REFUSED_SERVER_UNAVAILABLE);
                    MQTTProtocolConverter.this.getMQTTTransport().sendToMQTT(ack.encode());
                    MQTTProtocolConverter.this.getMQTTTransport().onException(IOExceptionSupport.create(exception));
                    return;
                }
                SessionInfo sessionInfo = new SessionInfo(MQTTProtocolConverter.this.sessionId);
                MQTTProtocolConverter.this.sendToBESMQ(sessionInfo, new ResponseHandler(){

                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                        if (response.isException()) {
                            Throwable exception = ((ExceptionResponse)response).getException();
                            CONNACK ack = new CONNACK();
                            ack.code(CONNACK.Code.CONNECTION_REFUSED_BAD_USERNAME_OR_PASSWORD);
                            MQTTProtocolConverter.this.getMQTTTransport().sendToMQTT(ack.encode());
                            MQTTProtocolConverter.this.getMQTTTransport().onException(IOExceptionSupport.create(exception));
                            return;
                        }
                        CONNACK ack = new CONNACK();
                        ack.code(CONNACK.Code.CONNECTION_ACCEPTED);
                        MQTTProtocolConverter.this.connected.set(true);
                        MQTTProtocolConverter.this.getMQTTTransport().sendToMQTT(ack.encode());
                        List<SubscriptionInfo> subs = PersistenceAdapterSupport.listSubscriptions(MQTTProtocolConverter.this.brokerService.getPersistenceAdapter(), MQTTProtocolConverter.this.connectionInfo.getClientId());
                        if (connect.cleanSession()) {
                            MQTTProtocolConverter.this.packetIdGenerator.stopClientSession(MQTTProtocolConverter.this.getClientId());
                            MQTTProtocolConverter.this.deleteDurableSubs(subs);
                        } else {
                            MQTTProtocolConverter.this.packetIdGenerator.startClientSession(MQTTProtocolConverter.this.getClientId());
                            MQTTProtocolConverter.this.restoreDurableSubs(subs);
                        }
                    }
                });
            }
        });
    }

    public void deleteDurableSubs(List<SubscriptionInfo> subs) {
        try {
            for (SubscriptionInfo sub : subs) {
                RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
                rsi.setConnectionId(this.connectionId);
                rsi.setSubscriptionName(sub.getSubcriptionName());
                rsi.setClientId(sub.getClientId());
                this.sendToBESMQ(rsi, new ResponseHandler(){

                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                    }
                });
            }
        }
        catch (Throwable e) {
            LOG.warn("Could not delete the MQTT durable subs.", e);
        }
    }

    public void restoreDurableSubs(List<SubscriptionInfo> subs) {
        try {
            for (SubscriptionInfo sub : subs) {
                String name = sub.getSubcriptionName();
                String[] split = name.split(":", 2);
                QoS qoS = QoS.valueOf((String)split[0]);
                this.onSubscribe(new Topic(split[1], qoS));
                this.restoredSubs.add(split[1]);
            }
        }
        catch (IOException e) {
            LOG.warn("Could not restore the MQTT durable subs.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTDisconnect() throws MQTTProtocolException {
        if (this.connected.get()) {
            this.connected.set(false);
            this.sendToBESMQ(this.connectionInfo.createRemoveCommand(), null);
            this.sendToBESMQ(new ShutdownInfo(), null);
        }
        Map<UTF8Buffer, ProducerInfo> map = this.topicProducerInfoMap;
        synchronized (map) {
            this.topicProducerInfoMap.clear();
        }
        this.stopTransport();
    }

    void onSubscribe(SUBSCRIBE command) throws MQTTProtocolException {
        this.checkConnected();
        Topic[] topics = command.topics();
        if (topics != null) {
            byte[] qos = new byte[topics.length];
            for (int i = 0; i < topics.length; ++i) {
                qos[i] = this.onSubscribe(topics[i]);
            }
            SUBACK ack = new SUBACK();
            ack.messageId(command.messageId());
            ack.grantedQos(qos);
            try {
                this.getMQTTTransport().sendToMQTT(ack.encode());
            }
            catch (IOException e) {
                LOG.warn("Couldn't send SUBACK for " + command, e);
            }
        } else {
            LOG.warn("No topics defined for subscription " + command);
        }
    }

    byte onSubscribe(Topic topic) throws MQTTProtocolException {
        final UTF8Buffer topicName = topic.name();
        final QoS topicQoS = topic.qos();
        BESMQTopic destination = new BESMQTopic(this.convertMQTTToBESMQ(topicName.toString()));
        if (this.mqttSubscriptionByTopic.containsKey(topicName)) {
            MQTTSubscription mqttSubscription = this.mqttSubscriptionByTopic.get(topicName);
            if (topicQoS == mqttSubscription.qos()) {
                this.resendRetainedMessages(topicName, destination, mqttSubscription);
                return (byte)topicQoS.ordinal();
            }
            this.onUnSubscribe(topicName);
            this.onUnSubscribe(topicName);
        }
        ConsumerId id = new ConsumerId(this.sessionId, this.consumerIdGenerator.getNextSequenceId());
        ConsumerInfo consumerInfo = new ConsumerInfo(id);
        consumerInfo.setDestination(destination);
        consumerInfo.setPrefetchSize(this.getBESMQSubscriptionPrefetch());
        consumerInfo.setRetroactive(true);
        consumerInfo.setDispatchAsync(true);
        if (!this.connect.cleanSession() && this.connect.clientId() != null && topicQoS.ordinal() >= QoS.AT_LEAST_ONCE.ordinal()) {
            consumerInfo.setSubscriptionName(topicQoS + ":" + topicName.toString());
        }
        MQTTSubscription mqttSubscription = new MQTTSubscription(this, topicQoS, consumerInfo);
        this.subscriptionsByConsumerId.put(id, mqttSubscription);
        this.mqttSubscriptionByTopic.put(topicName, mqttSubscription);
        final byte[] qos = new byte[]{-1};
        this.sendToBESMQ(consumerInfo, new ResponseHandler(){

            public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                if (response.isException()) {
                    Throwable throwable = ((ExceptionResponse)response).getException();
                    LOG.warn("Error subscribing to " + topicName, throwable);
                    qos[0] = -128;
                } else {
                    qos[0] = (byte)topicQoS.ordinal();
                }
            }
        });
        if (qos[0] == -128) {
            this.subscriptionsByConsumerId.remove(id);
            this.mqttSubscriptionByTopic.remove(topicName);
        }
        return qos[0];
    }

    private void resendRetainedMessages(UTF8Buffer topicName, BESMQDestination destination, MQTTSubscription mqttSubscription) throws MQTTProtocolException {
        RegionBroker regionBroker;
        if (this.restoredSubs.remove(destination.getPhysicalName())) {
            return;
        }
        try {
            regionBroker = (RegionBroker)this.brokerService.getBroker().getAdaptor(RegionBroker.class);
        }
        catch (Exception e) {
            throw new MQTTProtocolException("Error subscribing to " + topicName + ": " + e.getMessage(), false, e);
        }
        TopicRegion topicRegion = (TopicRegion)regionBroker.getTopicRegion();
        ConsumerInfo consumerInfo = mqttSubscription.getConsumerInfo();
        ConsumerId consumerId = consumerInfo.getConsumerId();
        String connectionInfoClientId = this.connectionInfo.getClientId();
        ConnectionContext connectionContext = regionBroker.getConnectionContext(connectionInfoClientId);
        Set<Destination> matchingDestinations = topicRegion.getDestinations(destination);
        block4: for (Destination dest : matchingDestinations) {
            for (Subscription subscription : dest.getConsumers()) {
                if (!subscription.getConsumerInfo().getConsumerId().equals(consumerId)) continue;
                try {
                    ((com.bes.mq.broker.region.Topic)dest).recoverRetroactiveMessages(connectionContext, subscription);
                    if (!(subscription instanceof PrefetchSubscription)) continue block4;
                    PrefetchSubscription prefetchSubscription = (PrefetchSubscription)subscription;
                    prefetchSubscription.dispatchPending();
                    continue block4;
                }
                catch (Exception e) {
                    throw new MQTTProtocolException("Error recovering retained messages for " + dest.getName() + ": " + e.getMessage(), false, e);
                }
            }
        }
    }

    void onUnSubscribe(UNSUBSCRIBE command) throws MQTTProtocolException {
        this.checkConnected();
        UTF8Buffer[] topics = command.topics();
        if (topics != null) {
            for (UTF8Buffer topic : topics) {
                this.onUnSubscribe(topic);
            }
        }
        UNSUBACK ack = new UNSUBACK();
        ack.messageId(command.messageId());
        this.sendToMQTT(ack.encode());
    }

    void onUnSubscribe(UTF8Buffer topicName) {
        MQTTSubscription subs = this.mqttSubscriptionByTopic.remove(topicName);
        if (subs != null) {
            ConsumerInfo info = subs.getConsumerInfo();
            if (info != null) {
                this.subscriptionsByConsumerId.remove(info.getConsumerId());
            }
            RemoveInfo removeInfo = null;
            if (info != null) {
                removeInfo = info.createRemoveCommand();
            }
            this.sendToBESMQ(removeInfo, null);
            if (subs.getConsumerInfo().getSubscriptionName() != null) {
                this.restoredSubs.remove(this.convertMQTTToBESMQ(topicName.toString()));
                RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
                rsi.setConnectionId(this.connectionId);
                rsi.setSubscriptionName(subs.getConsumerInfo().getSubscriptionName());
                rsi.setClientId(this.connectionInfo.getClientId());
                this.sendToBESMQ(rsi, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBESMQCommand(Command command) throws Exception {
        if (command.isResponse()) {
            Response response = (Response)command;
            ResponseHandler rh = this.resposeHandlers.remove(response.getCorrelationId());
            if (rh != null) {
                rh.onResponse(this, response);
            } else if (response.isException()) {
                Throwable exception = ((ExceptionResponse)response).getException();
                this.handleException(exception, null);
            }
        } else if (command.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)command;
            MQTTSubscription sub = this.subscriptionsByConsumerId.get(md.getConsumerId());
            if (sub != null) {
                MessageAck ack = sub.createMessageAck(md);
                PUBLISH publish = sub.createPublish((BESMQMessage)md.getMessage());
                switch (publish.qos()) {
                    case AT_LEAST_ONCE: 
                    case EXACTLY_ONCE: {
                        publish.dup(publish.dup() ? true : md.getMessage().isRedelivered());
                    }
                }
                if (ack != null && sub.expectAck(publish)) {
                    Map<Short, MessageAck> map = this.consumerAcks;
                    synchronized (map) {
                        this.consumerAcks.put(publish.messageId(), ack);
                    }
                }
                this.getMQTTTransport().sendToMQTT(publish.encode());
                if (ack != null && !sub.expectAck(publish)) {
                    this.getMQTTTransport().sendToBESMQ(ack);
                }
            }
        } else if (command.getDataStructureType() == 11) {
            Throwable exception = ((ConnectionError)command).getException();
            this.handleException(exception, null);
        } else if (!command.isBrokerInfo()) {
            LOG.debug("Do not know how to process BESMQ Command " + command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPublish(PUBLISH command) throws IOException, JMSException {
        this.checkConnected();
        ProducerId producerId = null;
        UTF8Buffer topicNameBuffer = command.topicName();
        if (!this.topicProducerInfoMap.containsKey(topicNameBuffer)) {
            BESMQTopic destination = new BESMQTopic(this.convertMQTTToBESMQ(topicNameBuffer.toString()));
            ProducerInfo producerInfo = new ProducerInfo();
            producerInfo.setDestination(destination);
            producerId = new ProducerId(this.sessionId, this.producerIdGenerator.getNextSequenceId());
            producerInfo.setProducerId(producerId);
            this.sendToBESMQ(producerInfo, new ResponseHandler(){

                public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                    if (response.isException()) {
                        Throwable exception = ((ExceptionResponse)response).getException();
                        throw IOExceptionSupport.create(exception);
                    }
                }
            });
            Map<UTF8Buffer, ProducerInfo> map = this.topicProducerInfoMap;
            synchronized (map) {
                this.topicProducerInfoMap.put(topicNameBuffer, producerInfo);
            }
        } else {
            ProducerInfo producerInfo = this.topicProducerInfoMap.get(topicNameBuffer);
            producerId = producerInfo.getProducerId();
        }
        BESMQMessage message = this.convertMessage(command, producerId);
        message.setProducerId(producerId);
        message.onSend();
        this.sendToBESMQ(message, this.createResponseHandler(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPubAck(PUBACK command) {
        MessageAck ack;
        short messageId = command.messageId();
        this.packetIdGenerator.ackPacketId(this.getClientId(), messageId);
        Map<Short, MessageAck> map = this.consumerAcks;
        synchronized (map) {
            ack = this.consumerAcks.remove(messageId);
        }
        if (ack != null) {
            this.getMQTTTransport().sendToBESMQ(ack);
        }
    }

    void onMQTTPubRec(PUBREC commnand) {
        PUBREL pubrel = new PUBREL();
        pubrel.messageId(commnand.messageId());
        this.sendToMQTT(pubrel.encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPubRel(PUBREL command) {
        PUBREC ack;
        Map<Short, PUBREC> map = this.publisherRecs;
        synchronized (map) {
            ack = this.publisherRecs.remove(command.messageId());
        }
        if (ack == null) {
            LOG.warn("Unknown PUBREL: " + command.messageId() + " received");
        }
        PUBCOMP pubcomp = new PUBCOMP();
        pubcomp.messageId(command.messageId());
        this.sendToMQTT(pubcomp.encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPubComp(PUBCOMP command) {
        MessageAck ack;
        short messageId = command.messageId();
        this.packetIdGenerator.ackPacketId(this.getClientId(), messageId);
        Map<Short, MessageAck> map = this.consumerAcks;
        synchronized (map) {
            ack = this.consumerAcks.remove(messageId);
        }
        if (ack != null) {
            this.getMQTTTransport().sendToBESMQ(ack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BESMQMessage convertMessage(PUBLISH command, ProducerId producerId) throws JMSException {
        BESMQTopic topic;
        BESMQBytesMessage msg = new BESMQBytesMessage();
        msg.setProducerId(producerId);
        MessageId id = new MessageId(producerId, this.publisherIdGenerator.getNextSequenceId());
        msg.setMessageId(id);
        msg.setTimestamp(System.currentTimeMillis());
        msg.setPriority((byte)4);
        msg.setPersistent(command.qos() != QoS.AT_MOST_ONCE && !command.retain());
        msg.setIntProperty(QOS_PROPERTY_NAME, command.qos().ordinal());
        if (command.retain()) {
            msg.setBooleanProperty("BESMQ.Retain", true);
        }
        Map<UTF8Buffer, BESMQTopic> map = this.besMQTopicMap;
        synchronized (map) {
            topic = this.besMQTopicMap.get(command.topicName());
            if (topic == null) {
                String topicName = this.convertMQTTToBESMQ(command.topicName().toString());
                topic = new BESMQTopic(topicName);
                this.besMQTopicMap.put(command.topicName(), topic);
            }
        }
        msg.setJMSDestination(topic);
        msg.writeBytes(command.payload().data, command.payload().offset, command.payload().length);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PUBLISH convertMessage(BESMQMessage message) throws IOException, JMSException, DataFormatException {
        BESMQMessage msg;
        UTF8Buffer topicName;
        QoS qoS;
        PUBLISH result = new PUBLISH();
        if (message.propertyExists(QOS_PROPERTY_NAME)) {
            int ordinal = message.getIntProperty(QOS_PROPERTY_NAME);
            qoS = QoS.values()[ordinal];
        } else {
            qoS = message.isPersistent() ? QoS.AT_MOST_ONCE : QoS.AT_LEAST_ONCE;
        }
        result.qos(qoS);
        if (message.getBooleanProperty("BESMQ.Retained")) {
            result.retain(true);
        }
        Map<javax.jms.Destination, UTF8Buffer> map = this.mqttTopicMap;
        synchronized (map) {
            topicName = this.mqttTopicMap.get(message.getJMSDestination());
            if (topicName == null) {
                topicName = new UTF8Buffer(this.convertBESMQToMQTT(message.getDestination().getPhysicalName()));
                this.mqttTopicMap.put(message.getJMSDestination(), topicName);
            }
        }
        result.topicName(topicName);
        if (message.getDataStructureType() == 39) {
            msg = (BESMQTextMessage)message.copy();
            msg.setReadOnlyBody(true);
            String messageText = ((BESMQTextMessage)msg).getText();
            if (messageText != null) {
                result.payload(new Buffer(messageText.getBytes("UTF-8")));
            }
        } else if (message.getDataStructureType() == 35) {
            msg = (BESMQBytesMessage)message.copy();
            msg.setReadOnlyBody(true);
            byte[] data = new byte[(int)((BESMQBytesMessage)msg).getBodyLength()];
            ((BESMQBytesMessage)msg).readBytes(data);
            result.payload(new Buffer(data));
        } else if (message.getDataStructureType() == 36) {
            msg = (BESMQMapMessage)message.copy();
            msg.setReadOnlyBody(true);
            Map<String, Object> map2 = ((BESMQMapMessage)msg).getContentMap();
            if (map2 != null) {
                result.payload(new Buffer(map2.toString().getBytes("UTF-8")));
            }
        } else {
            ByteSequence byteSequence = message.getContent();
            if (byteSequence != null && byteSequence.getLength() > 0) {
                if (message.isCompressed()) {
                    int read;
                    Inflater inflater = new Inflater();
                    inflater.setInput(byteSequence.data, byteSequence.offset, byteSequence.length);
                    byte[] data = new byte[4096];
                    ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                    while ((read = inflater.inflate(data)) != 0) {
                        bytesOut.write(data, 0, read);
                    }
                    byteSequence = bytesOut.toByteSequence();
                    bytesOut.close();
                }
                result.payload(new Buffer(byteSequence.data, byteSequence.offset, byteSequence.length));
            }
        }
        return result;
    }

    private String convertBESMQToMQTT(String physicalName) {
        return physicalName.replace('.', '/');
    }

    public MQTTTransport getMQTTTransport() {
        return this.mqttTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTransportError() {
        if (this.connect != null && this.connected.get()) {
            if (this.connect.willTopic() != null && this.connect.willMessage() != null && !this.willSent) {
                this.willSent = true;
                try {
                    ProducerInfo producerInfo;
                    PUBLISH publish = new PUBLISH();
                    publish.topicName(this.connect.willTopic());
                    publish.qos(this.connect.willQos());
                    publish.messageId(this.packetIdGenerator.getNextSequenceId(this.getClientId()));
                    publish.payload((Buffer)this.connect.willMessage());
                    ProducerId producerId = null;
                    if (this.topicProducerInfoMap.containsKey(this.connect.willTopic())) {
                        producerInfo = this.topicProducerInfoMap.get(this.connect.willTopic());
                        producerId = producerInfo.getProducerId();
                    } else {
                        producerId = new ProducerId(this.sessionId, this.producerIdGenerator.getNextSequenceId());
                        producerInfo = new ProducerInfo();
                        producerInfo.setProducerId(producerId);
                        Map<UTF8Buffer, ProducerInfo> map = this.topicProducerInfoMap;
                        synchronized (map) {
                            this.topicProducerInfoMap.put(this.connect.willTopic(), producerInfo);
                        }
                    }
                    BESMQMessage message = this.convertMessage(publish, producerId);
                    message.setProducerId(producerId);
                    message.onSend();
                    this.sendToBESMQ(message, null);
                }
                catch (Exception e) {
                    LOG.warn("Failed to publish Will Message " + this.connect.willMessage());
                }
            }
            this.sendToBESMQ(this.connectionInfo.createRemoveCommand(), null);
        }
    }

    void configureInactivityMonitor(short keepAliveSeconds) {
        MQTTInactivityMonitor monitor = this.getMQTTTransport().getInactivityMonitor();
        if (monitor == null) {
            return;
        }
        long keepAliveMS = keepAliveSeconds * 1000;
        if (LOG.isDebugEnabled()) {
            LOG.debug("MQTT Client " + this.getClientId() + " requests heart beat of  " + keepAliveMS + " ms");
        }
        try {
            if (keepAliveMS == 0L && this.defaultKeepAlive > 0L) {
                keepAliveMS = this.defaultKeepAlive;
            }
            long readGracePeriod = (long)((double)keepAliveMS * 0.5);
            monitor.setProtocolConverter(this);
            monitor.setReadKeepAliveTime(keepAliveMS);
            monitor.setReadGraceTime(readGracePeriod);
            monitor.startMonitorThread();
            if (LOG.isDebugEnabled()) {
                LOG.debug("MQTT Client " + this.getClientId() + " established heart beat of  " + keepAliveMS + " ms (" + keepAliveMS + "ms + " + readGracePeriod + "ms grace period)");
            }
        }
        catch (Exception ex) {
            LOG.warn("Failed to start MQTT InactivityMonitor ", ex);
        }
    }

    void handleException(Throwable exception, MQTTFrame command) {
        LOG.warn("Exception occurred processing: \n" + command + ": " + exception.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exception detail", exception);
        }
        if (this.connected.get() && this.connectionInfo != null) {
            this.connected.set(false);
            this.sendToBESMQ(this.connectionInfo.createRemoveCommand(), null);
        }
        this.stopTransport();
    }

    void checkConnected() throws MQTTProtocolException {
        if (!this.connected.get()) {
            throw new MQTTProtocolException("Not connected.");
        }
    }

    String getClientId() {
        if (this.clientId == null) {
            this.clientId = this.connect != null && this.connect.clientId() != null ? this.connect.clientId().toString() : "";
        }
        return this.clientId;
    }

    private void stopTransport() {
        try {
            this.getMQTTTransport().stop();
        }
        catch (Throwable e) {
            LOG.debug("Failed to stop MQTT transport ", e);
        }
    }

    ResponseHandler createResponseHandler(final PUBLISH command) {
        if (command != null) {
            switch (command.qos()) {
                case AT_LEAST_ONCE: {
                    return new ResponseHandler(){

                        public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                            if (response.isException()) {
                                LOG.warn("Failed to send MQTT PUBLISH: ", command, (Object)((ExceptionResponse)response).getException());
                            } else {
                                PUBACK ack = new PUBACK();
                                ack.messageId(command.messageId());
                                converter.getMQTTTransport().sendToMQTT(ack.encode());
                            }
                        }
                    };
                }
                case EXACTLY_ONCE: {
                    return new ResponseHandler(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                            if (response.isException()) {
                                LOG.warn("Failed to send MQTT PUBLISH: ", command, (Object)((ExceptionResponse)response).getException());
                            } else {
                                PUBREC ack = new PUBREC();
                                ack.messageId(command.messageId());
                                Map map = MQTTProtocolConverter.this.publisherRecs;
                                synchronized (map) {
                                    MQTTProtocolConverter.this.publisherRecs.put(command.messageId(), ack);
                                }
                                converter.getMQTTTransport().sendToMQTT(ack.encode());
                            }
                        }
                    };
                }
            }
        }
        return null;
    }

    private String convertMQTTToBESMQ(String name) {
        char[] chars = name.toCharArray();
        block8: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '#': {
                    chars[i] = 62;
                    continue block8;
                }
                case '>': {
                    chars[i] = 35;
                    continue block8;
                }
                case '+': {
                    chars[i] = 42;
                    continue block8;
                }
                case '*': {
                    chars[i] = 43;
                    continue block8;
                }
                case '/': {
                    chars[i] = 46;
                    continue block8;
                }
                case '.': {
                    chars[i] = 47;
                }
            }
        }
        String rc = new String(chars);
        return rc;
    }

    public long getDefaultKeepAlive() {
        return this.defaultKeepAlive;
    }

    public void setDefaultKeepAlive(long keepAlive) {
        this.defaultKeepAlive = keepAlive;
    }

    public int getBESMQSubscriptionPrefetch() {
        return this.besMQSubscriptionPrefetch;
    }

    public void setBESMQSubscriptionPrefetch(int besMQSubscriptionPrefetch) {
        this.besMQSubscriptionPrefetch = besMQSubscriptionPrefetch;
    }

    public MQTTPacketIdGenerator getPacketIdGenerator() {
        return this.packetIdGenerator;
    }
}

