/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.mqtt;

import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.mqtt.client.QoS;
import com.bes.mq.mqtt.codec.PUBLISH;
import com.bes.mq.transport.mqtt.MQTTProtocolConverter;
import java.io.IOException;
import java.util.zip.DataFormatException;
import javax.jms.JMSException;

class MQTTSubscription {
    private final MQTTProtocolConverter protocolConverter;
    private final ConsumerInfo consumerInfo;
    private BESMQDestination destination;
    private final QoS qos;

    public MQTTSubscription(MQTTProtocolConverter protocolConverter, QoS qos, ConsumerInfo consumerInfo) {
        this.protocolConverter = protocolConverter;
        this.consumerInfo = consumerInfo;
        this.qos = qos;
    }

    MessageAck createMessageAck(MessageDispatch md) {
        return new MessageAck(md, 2, 1);
    }

    PUBLISH createPublish(BESMQMessage message) throws DataFormatException, IOException, JMSException {
        PUBLISH publish = this.protocolConverter.convertMessage(message);
        if (publish.qos().ordinal() > this.qos.ordinal()) {
            publish.qos(this.qos);
        }
        switch (publish.qos()) {
            case AT_LEAST_ONCE: 
            case EXACTLY_ONCE: {
                this.protocolConverter.getPacketIdGenerator().setPacketId(this.protocolConverter.getClientId(), this, message, publish);
            }
        }
        return publish;
    }

    public boolean expectAck(PUBLISH publish) {
        QoS publishQoS = publish.qos();
        if (publishQoS.compareTo((Enum)this.qos) > 0) {
            publishQoS = this.qos;
        }
        return !publishQoS.equals((Object)QoS.AT_MOST_ONCE);
    }

    public ConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }

    public QoS qos() {
        return this.qos;
    }
}

