/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.mqtt;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.BrokerServiceAware;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.MutexTransport;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.mqtt.MQTTInactivityMonitor;
import com.bes.mq.transport.mqtt.MQTTTransportFilter;
import com.bes.mq.transport.tcp.TcpTransportFactory;
import com.bes.mq.transport.tcp.TcpTransportServer;
import com.bes.mq.util.IntrospectionSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;

public class MQTTTransportFactory
extends TcpTransportFactory
implements BrokerServiceAware {
    private BrokerService brokerService = null;

    protected String getDefaultProtocolFormatType() {
        return "mqtt";
    }

    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new TcpTransportServer(this, location, serverSocketFactory);
    }

    public Transport compositeConfigure(Transport transport, ProtocolFormat format, Map options) {
        transport = new MQTTTransportFilter(transport, format, this.brokerService);
        IntrospectionSupport.setProperties(transport, options);
        return super.compositeConfigure(transport, format, options);
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    public Transport serverConfigure(Transport transport, ProtocolFormat format, HashMap options) throws Exception {
        MutexTransport mutex = (transport = super.serverConfigure(transport, format, options)).narrow(MutexTransport.class);
        if (mutex != null) {
            mutex.setSyncOnCommand(true);
        }
        return transport;
    }

    protected Transport createInactivityMonitor(Transport transport, ProtocolFormat format) {
        MQTTInactivityMonitor monitor = new MQTTInactivityMonitor(transport, format);
        MQTTTransportFilter filter = transport.narrow(MQTTTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

