/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.mqtt;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.command.Command;
import com.bes.mq.mqtt.codec.CONNACK;
import com.bes.mq.mqtt.codec.CONNECT;
import com.bes.mq.mqtt.codec.DISCONNECT;
import com.bes.mq.mqtt.codec.MQTTFrame;
import com.bes.mq.mqtt.codec.PINGREQ;
import com.bes.mq.mqtt.codec.PINGRESP;
import com.bes.mq.mqtt.codec.PUBACK;
import com.bes.mq.mqtt.codec.PUBCOMP;
import com.bes.mq.mqtt.codec.PUBLISH;
import com.bes.mq.mqtt.codec.PUBREC;
import com.bes.mq.mqtt.codec.PUBREL;
import com.bes.mq.mqtt.codec.SUBACK;
import com.bes.mq.mqtt.codec.SUBSCRIBE;
import com.bes.mq.mqtt.codec.UNSUBSCRIBE;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFilter;
import com.bes.mq.transport.TransportListener;
import com.bes.mq.transport.mqtt.MQTTInactivityMonitor;
import com.bes.mq.transport.mqtt.MQTTProtocolConverter;
import com.bes.mq.transport.mqtt.MQTTProtocolFormat;
import com.bes.mq.transport.mqtt.MQTTTransport;
import com.bes.mq.transport.tcp.SslTransport;
import com.bes.mq.util.IOExceptionSupport;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;

public class MQTTTransportFilter
extends TransportFilter
implements MQTTTransport {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTTransportFilter.class);
    private static final Logger TRACE = LoggerFactory.getLogger(MQTTTransportFilter.class.getPackage().getName() + ".MQTTIO");
    private final MQTTProtocolConverter protocolConverter;
    private MQTTInactivityMonitor monitor;
    private MQTTProtocolFormat protocolFormat;
    private final AtomicBoolean stopped = new AtomicBoolean();
    private boolean trace;
    private final Object sendLock = new Object();

    public MQTTTransportFilter(Transport next, ProtocolFormat protocolFormat, BrokerService brokerService) {
        super(next);
        this.protocolConverter = new MQTTProtocolConverter(this, brokerService);
        if (protocolFormat instanceof MQTTProtocolFormat) {
            this.protocolFormat = (MQTTProtocolFormat)protocolFormat;
        }
    }

    public void oneway(Object o) throws IOException {
        try {
            Command command = (Command)o;
            this.protocolConverter.onBESMQCommand(command);
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public void onCommand(Object command) {
        try {
            MQTTFrame frame = (MQTTFrame)command;
            if (this.trace) {
                TRACE.trace("Received: " + MQTTTransportFilter.toString(frame));
            }
            this.protocolConverter.onMQTTCommand(frame);
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (JMSException e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    public void sendToBESMQ(Command command) {
        TransportListener l = this.transportListener;
        if (l != null) {
            l.onCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToMQTT(MQTTFrame command) throws IOException {
        if (!this.stopped.get()) {
            Transport n;
            if (this.trace) {
                TRACE.trace("Sending : " + MQTTTransportFilter.toString(command));
            }
            if ((n = this.next) != null) {
                Object object = this.sendLock;
                synchronized (object) {
                    n.oneway(command);
                }
            }
        }
    }

    private static String toString(MQTTFrame frame) {
        if (frame == null) {
            return null;
        }
        try {
            switch (frame.messageType()) {
                case 12: {
                    return new PINGREQ().decode(frame).toString();
                }
                case 13: {
                    return new PINGRESP().decode(frame).toString();
                }
                case 1: {
                    return new CONNECT().decode(frame).toString();
                }
                case 14: {
                    return new DISCONNECT().decode(frame).toString();
                }
                case 8: {
                    return new SUBSCRIBE().decode(frame).toString();
                }
                case 10: {
                    return new UNSUBSCRIBE().decode(frame).toString();
                }
                case 3: {
                    return new PUBLISH().decode(frame).toString();
                }
                case 4: {
                    return new PUBACK().decode(frame).toString();
                }
                case 5: {
                    return new PUBREC().decode(frame).toString();
                }
                case 6: {
                    return new PUBREL().decode(frame).toString();
                }
                case 7: {
                    return new PUBCOMP().decode(frame).toString();
                }
                case 2: {
                    return new CONNACK().decode(frame).toString();
                }
                case 9: {
                    return new SUBACK().decode(frame).toString();
                }
            }
            return frame.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return frame.toString();
        }
    }

    public void stop() throws Exception {
        if (this.stopped.compareAndSet(false, true)) {
            super.stop();
        }
    }

    public X509Certificate[] getPeerCertificates() {
        if (this.next instanceof SslTransport) {
            X509Certificate[] peerCerts = ((SslTransport)this.next).getPeerCertificates();
            if (this.trace && peerCerts != null) {
                LOG.debug("Peer Identity has been verified\n");
            }
            return peerCerts;
        }
        return null;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public MQTTInactivityMonitor getInactivityMonitor() {
        return this.monitor;
    }

    public void setInactivityMonitor(MQTTInactivityMonitor monitor) {
        this.monitor = monitor;
    }

    public MQTTProtocolFormat getProtocolFormat() {
        return this.protocolFormat;
    }

    public void onException(IOException error) {
        this.protocolConverter.onTransportError();
        super.onException(error);
    }

    public long getDefaultKeepAlive() {
        return this.protocolConverter != null ? this.protocolConverter.getDefaultKeepAlive() : -1L;
    }

    public void setDefaultKeepAlive(long defaultHeartBeat) {
        this.protocolConverter.setDefaultKeepAlive(defaultHeartBeat);
    }

    public int getBESMQSubscriptionPrefetch() {
        return this.protocolConverter.getBESMQSubscriptionPrefetch();
    }

    public void setBESMQSubscriptionPrefetch(int besMQSubscriptionPrefetch) {
        this.protocolConverter.setBESMQSubscriptionPrefetch(besMQSubscriptionPrefetch);
    }
}

