/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.multicast;

import com.bes.mq.command.Command;
import com.bes.mq.command.Endpoint;
import com.bes.mq.transport.udp.DatagramEndpoint;
import com.bes.mq.transport.udp.DatagramHeaderMarshaller;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public class MulticastDatagramHeaderMarshaller
extends DatagramHeaderMarshaller {
    private final byte[] localUriAsBytes;

    public MulticastDatagramHeaderMarshaller(String localUri) {
        this.localUriAsBytes = localUri.getBytes();
    }

    public Endpoint createEndpoint(ByteBuffer readBuffer, SocketAddress address) {
        int size = readBuffer.getInt();
        byte[] data = new byte[size];
        readBuffer.get(data);
        return new DatagramEndpoint(new String(data), address);
    }

    public void writeHeader(Command command, ByteBuffer writeBuffer) {
        writeBuffer.putInt(this.localUriAsBytes.length);
        writeBuffer.put(this.localUriAsBytes);
        super.writeHeader(command, writeBuffer);
    }
}

