/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.multicast;

import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.multicast.MulticastDatagramHeaderMarshaller;
import com.bes.mq.transport.udp.CommandChannel;
import com.bes.mq.transport.udp.CommandDatagramSocket;
import com.bes.mq.transport.udp.DatagramHeaderMarshaller;
import com.bes.mq.transport.udp.UdpTransport;
import com.bes.mq.util.ServiceStopper;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;

public class MulticastTransport
extends UdpTransport {
    private static final Logger LOG = LoggerFactory.getLogger(MulticastTransport.class);
    private static final int DEFAULT_IDLE_TIME = 5000;
    private MulticastSocket socket;
    private InetAddress mcastAddress;
    private int mcastPort;
    private int timeToLive = 1;
    private boolean loopBackMode;
    private long keepAliveInterval = 5000L;

    public MulticastTransport(BESMPFormat protocolFormat, URI remoteLocation) throws UnknownHostException, IOException {
        super(protocolFormat, remoteLocation);
    }

    public long getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(long keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public boolean isLoopBackMode() {
        return this.loopBackMode;
    }

    public void setLoopBackMode(boolean loopBackMode) {
        this.loopBackMode = loopBackMode;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    protected String getProtocolName() {
        return "Multicast";
    }

    protected String getProtocolUriScheme() {
        return "multicast://";
    }

    protected void bind(DatagramSocket socket, SocketAddress localAddress) throws SocketException {
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        super.doStop(stopper);
        if (this.socket != null) {
            try {
                this.socket.leaveGroup(this.getMulticastAddress());
            }
            catch (IOException e) {
                stopper.onException(this, e);
            }
            this.socket.close();
        }
    }

    protected CommandChannel createCommandChannel() throws IOException {
        this.socket = new MulticastSocket(this.mcastPort);
        this.socket.setLoopbackMode(this.loopBackMode);
        this.socket.setTimeToLive(this.timeToLive);
        LOG.debug("Joining multicast address: " + this.getMulticastAddress());
        this.socket.joinGroup(this.getMulticastAddress());
        this.socket.setSoTimeout((int)this.keepAliveInterval);
        return new CommandDatagramSocket(this, this.getProtocolFormat(), this.getDatagramSize(), this.getTargetAddress(), this.createDatagramHeaderMarshaller(), this.getSocket());
    }

    protected InetAddress getMulticastAddress() {
        return this.mcastAddress;
    }

    protected MulticastSocket getSocket() {
        return this.socket;
    }

    protected void setSocket(MulticastSocket socket) {
        this.socket = socket;
    }

    protected InetSocketAddress createAddress(URI remoteLocation) throws UnknownHostException, IOException {
        this.mcastAddress = InetAddress.getByName(remoteLocation.getHost());
        this.mcastPort = remoteLocation.getPort();
        return new InetSocketAddress(this.mcastAddress, this.mcastPort);
    }

    protected DatagramHeaderMarshaller createDatagramHeaderMarshaller() {
        return new MulticastDatagramHeaderMarshaller("udp://dummyHostName:" + this.getPort());
    }
}

