/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.nio;

import com.bes.mq.command.Command;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.thread.TaskRunnerFactory;
import com.bes.mq.transport.nio.NIOInputStream;
import com.bes.mq.transport.nio.NIOOutputStream;
import com.bes.mq.transport.nio.NIOTransport;
import com.bes.mq.transport.nio.SelectorManager;
import com.bes.mq.transport.nio.SelectorSelection;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.ServiceStopper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class NIOSSLTransport
extends NIOTransport {
    private static final Logger logger = LoggerFactory.getLogger(NIOSSLTransport.class);
    protected boolean needClientAuth;
    protected boolean wantClientAuth;
    protected String[] enabledCipherSuites;
    protected SSLContext sslContext;
    protected SSLEngine sslEngine;
    protected SSLSession sslSession;
    protected volatile boolean handshakeInProgress = false;
    protected SSLEngineResult.Status status = null;
    protected SSLEngineResult.HandshakeStatus handshakeStatus = null;
    protected TaskRunnerFactory taskRunnerFactory;

    public NIOSSLTransport(ProtocolFormat protocolFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        super(protocolFormat, socketFactory, remoteLocation, localLocation);
    }

    public NIOSSLTransport(ProtocolFormat protocolFormat, Socket socket) throws IOException {
        super(protocolFormat, socket);
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    protected void initializeStreams() throws IOException {
        try {
            this.channel = this.socket.getChannel();
            this.channel.configureBlocking(false);
            if (this.sslContext == null) {
                this.sslContext = SSLContext.getDefault();
            }
            this.sslEngine = this.sslContext.createSSLEngine();
            this.sslEngine.setUseClientMode(false);
            if (this.enabledCipherSuites != null) {
                this.sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            this.sslEngine.setNeedClientAuth(this.needClientAuth);
            this.sslEngine.setWantClientAuth(this.wantClientAuth);
            this.sslSession = this.sslEngine.getSession();
            this.inputBuffer = ByteBuffer.allocate(this.sslSession.getPacketBufferSize());
            this.inputBuffer.clear();
            this.currentBuffer = ByteBuffer.allocate(this.sslSession.getApplicationBufferSize());
            NIOOutputStream outputStream = new NIOOutputStream(this.channel);
            outputStream.setEngine(this.sslEngine);
            this.dataOut = new DataOutputStream(outputStream);
            this.buffOut = outputStream;
            this.sslEngine.beginHandshake();
            this.handshakeStatus = this.sslEngine.getHandshakeStatus();
            this.doHandshake();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void finishHandshake() throws Exception {
        if (this.handshakeInProgress) {
            this.handshakeInProgress = false;
            this.nextFrameSize = -1;
            this.sslSession = this.sslEngine.getSession();
            this.selection = SelectorManager.getInstance().register(this.channel, new SelectorManager.Listener(){

                public void onSelect(SelectorSelection selection) {
                    NIOSSLTransport.this.serviceRead();
                }

                public void onError(SelectorSelection selection, Throwable error) {
                    if (error instanceof IOException) {
                        NIOSSLTransport.this.onException((IOException)error);
                    } else {
                        NIOSSLTransport.this.onException(IOExceptionSupport.create(error));
                    }
                }
            });
        }
    }

    protected void serviceRead() {
        try {
            if (this.handshakeInProgress) {
                this.doHandshake();
            }
            ByteBuffer plain = ByteBuffer.allocate(this.sslSession.getApplicationBufferSize());
            plain.position(plain.limit());
            while (true) {
                if (!plain.hasRemaining()) {
                    if (this.status == SSLEngineResult.Status.OK && this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                        plain.clear();
                    } else {
                        plain.compact();
                    }
                    int readCount = this.secureRead(plain);
                    if (readCount == 0) break;
                    if (readCount == -1) {
                        this.onException(new EOFException());
                        this.selection.close();
                        break;
                    }
                }
                if (this.status != SSLEngineResult.Status.OK || this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) continue;
                this.processCommand(plain);
            }
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (Throwable e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    protected void processCommand(ByteBuffer plain) throws Exception {
        if (this.nextFrameSize == -1) {
            if (plain.remaining() < 32) {
                if (this.currentBuffer == null) {
                    this.currentBuffer = ByteBuffer.allocate(4);
                }
                while (this.currentBuffer.hasRemaining() && plain.hasRemaining()) {
                    this.currentBuffer.put(plain.get());
                }
                if (this.currentBuffer.hasRemaining()) {
                    return;
                }
                this.currentBuffer.flip();
                this.nextFrameSize = this.currentBuffer.getInt();
            } else if (this.currentBuffer != null) {
                int pr = plain.limit() - plain.position();
                int cr = this.currentBuffer.limit() - this.currentBuffer.position();
                if (cr <= pr) {
                    while (this.currentBuffer.hasRemaining()) {
                        this.currentBuffer.put(plain.get());
                    }
                    this.currentBuffer.flip();
                    this.nextFrameSize = this.currentBuffer.getInt();
                } else {
                    this.nextFrameSize = plain.getInt();
                }
            } else {
                this.nextFrameSize = plain.getInt();
            }
            this.currentBuffer = ByteBuffer.allocate(this.nextFrameSize + 4);
            this.currentBuffer.putInt(this.nextFrameSize);
        } else {
            if (this.currentBuffer.remaining() >= plain.remaining()) {
                this.currentBuffer.put(plain);
            } else {
                byte[] fill = new byte[this.currentBuffer.remaining()];
                plain.get(fill);
                this.currentBuffer.put(fill);
            }
            if (this.currentBuffer.hasRemaining()) {
                return;
            }
            this.currentBuffer.flip();
            Object command = this.protocolFormat.unmarshal(new DataInputStream(new NIOInputStream(this.currentBuffer)));
            this.doConsume((Command)command);
            this.nextFrameSize = -1;
            this.currentBuffer = null;
        }
    }

    protected int secureRead(ByteBuffer plain) throws Exception {
        SSLEngineResult res;
        int bytesRead;
        if (!(this.inputBuffer.position() != 0 && this.inputBuffer.hasRemaining() && this.status != SSLEngineResult.Status.BUFFER_UNDERFLOW || (bytesRead = this.channel.read(this.inputBuffer)) != -1)) {
            this.sslEngine.closeInbound();
            if (this.inputBuffer.position() == 0 || this.status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                return -1;
            }
        }
        plain.clear();
        this.inputBuffer.flip();
        while ((res = this.sslEngine.unwrap(this.inputBuffer, plain)).getStatus() == SSLEngineResult.Status.OK && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && res.bytesProduced() == 0) {
        }
        if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.finishHandshake();
        }
        this.status = res.getStatus();
        this.handshakeStatus = res.getHandshakeStatus();
        if (this.status == SSLEngineResult.Status.CLOSED) {
            this.sslEngine.closeInbound();
            return -1;
        }
        this.inputBuffer.compact();
        plain.flip();
        return plain.remaining();
    }

    protected void doHandshake() throws Exception {
        this.handshakeInProgress = true;
        block6: while (true) {
            switch (this.sslEngine.getHandshakeStatus()) {
                case NEED_UNWRAP: {
                    this.secureRead(ByteBuffer.allocate(this.sslSession.getApplicationBufferSize()));
                    break;
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = this.sslEngine.getDelegatedTask()) != null) {
                        this.taskRunnerFactory.execute(task);
                    }
                    continue block6;
                }
                case NEED_WRAP: {
                    ((NIOOutputStream)this.buffOut).write(ByteBuffer.allocate(0));
                    break;
                }
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    this.finishHandshake();
                    return;
                }
            }
        }
    }

    protected void doStart() throws Exception {
        this.taskRunnerFactory = new TaskRunnerFactory("BESMQ NIOSSLTransport Task");
        super.doStart();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        if (this.taskRunnerFactory != null) {
            this.taskRunnerFactory.shutdownNow();
            this.taskRunnerFactory = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        super.doStop(stopper);
    }

    public void doConsume(Object command) {
        if (command instanceof ConnectionInfo) {
            ConnectionInfo connectionInfo = (ConnectionInfo)command;
            connectionInfo.setTransportContext(this.getPeerCertificates());
        }
        super.doConsume(command);
    }

    public X509Certificate[] getPeerCertificates() {
        X509Certificate[] clientCertChain = null;
        try {
            if (this.sslSession != null) {
                clientCertChain = (X509Certificate[])this.sslSession.getPeerCertificates();
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            // empty catch block
        }
        return clientCertChain;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String toString() {
        return "tcp://" + this.socket.getInetAddress() + ":" + this.socket.getPort() + "?enableSSL=true&socketType=nio";
    }
}

