/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.nio;

import com.bes.mq.broker.SslContext;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportServer;
import com.bes.mq.transport.nio.NIOSSLTransport;
import com.bes.mq.transport.nio.NIOTransportFactory;
import com.bes.mq.transport.tcp.SslTransport;
import com.bes.mq.transport.tcp.TcpTransportServer;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.IntrospectionSupport;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class NIOSSLTransportFactory
extends NIOTransportFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NIOSSLTransportFactory.class);
    SSLContext context;

    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new TcpTransportServer(this, location, serverSocketFactory){

            protected Transport createTransport(Socket socket, ProtocolFormat format) throws IOException {
                NIOSSLTransport transport = new NIOSSLTransport(format, socket);
                if (NIOSSLTransportFactory.this.context != null) {
                    transport.setSslContext(NIOSSLTransportFactory.this.context);
                }
                return transport;
            }
        };
    }

    public TransportServer doBind(URI location) throws IOException {
        if (SslContext.getCurrentSslContext() != null) {
            try {
                this.context = SslContext.getCurrentSslContext().getSSLContext();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return super.doBind(location);
    }

    public Transport compositeConfigure(Transport transport, ProtocolFormat format, Map options) {
        if (transport instanceof SslTransport) {
            SslTransport sslTransport = transport.narrow(SslTransport.class);
            IntrospectionSupport.setProperties(sslTransport, options);
        } else if (transport instanceof NIOSSLTransport) {
            NIOSSLTransport sslTransport = transport.narrow(NIOSSLTransport.class);
            IntrospectionSupport.setProperties(sslTransport, options);
        }
        return super.compositeConfigure(transport, format, options);
    }

    protected Transport createTransport(URI location, ProtocolFormat wf) throws UnknownHostException, IOException {
        URI localLocation = null;
        String path = location.getPath();
        if (path != null && path.length() > 0) {
            int localPortIndex = path.indexOf(58);
            try {
                Integer.parseInt(path.substring(localPortIndex + 1, path.length()));
                String localString = location.getScheme() + ":/" + path;
                localLocation = new URI(localString);
            }
            catch (Exception e) {
                LOG.warn("Path isn't a valid local location for SslTransport to use", e);
            }
        }
        SocketFactory socketFactory = this.createSocketFactory();
        return new SslTransport(wf, (SSLSocketFactory)socketFactory, location, localLocation, false);
    }

    protected SocketFactory createSocketFactory() throws IOException {
        if (SslContext.getCurrentSslContext() != null) {
            SslContext ctx = SslContext.getCurrentSslContext();
            try {
                return ctx.getSSLContext().getSocketFactory();
            }
            catch (Exception e) {
                throw IOExceptionSupport.create(e);
            }
        }
        return SSLSocketFactory.getDefault();
    }
}

