/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.nio;

import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.nio.NIOSSLTransport;
import com.bes.mq.transport.tcp.TcpTransportFactory;
import com.bes.mq.transport.tcp.TcpTransportServer;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;

public class NIOSSLTransportServer
extends TcpTransportServer {
    private SSLContext context;
    private boolean needClientAuth;
    private boolean wantClientAuth;

    public NIOSSLTransportServer(SSLContext context, TcpTransportFactory transportFactory, URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        super(transportFactory, location, serverSocketFactory);
        this.context = context;
    }

    protected Transport createTransport(Socket socket, ProtocolFormat format) throws IOException {
        NIOSSLTransport transport = new NIOSSLTransport(format, socket);
        if (this.context != null) {
            transport.setSslContext(this.context);
        }
        transport.setNeedClientAuth(this.needClientAuth);
        transport.setWantClientAuth(this.wantClientAuth);
        return transport;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean value) {
        this.needClientAuth = value;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean value) {
        this.wantClientAuth = value;
    }
}

