/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.nio;

import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.command.Command;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.nio.NIOInputStream;
import com.bes.mq.transport.nio.NIOOutputStream;
import com.bes.mq.transport.nio.SelectorManager;
import com.bes.mq.transport.nio.SelectorSelection;
import com.bes.mq.transport.tcp.TcpTransport;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.ServiceStopper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.SocketFactory;

public class NIOTransport
extends TcpTransport {
    protected SocketChannel channel;
    protected SelectorSelection selection;
    protected ByteBuffer inputBuffer;
    protected ByteBuffer currentBuffer;
    protected int nextFrameSize;

    public NIOTransport(ProtocolFormat protocolFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        super(protocolFormat, socketFactory, remoteLocation, localLocation);
    }

    public NIOTransport(ProtocolFormat protocolFormat, Socket socket) throws IOException {
        super(protocolFormat, socket);
    }

    protected void initializeStreams() throws IOException {
        this.channel = this.socket.getChannel();
        this.channel.configureBlocking(false);
        this.selection = SelectorManager.getInstance().register(this.channel, new SelectorManager.Listener(){

            public void onSelect(SelectorSelection selection) {
                NIOTransport.this.serviceRead();
            }

            public void onError(SelectorSelection selection, Throwable error) {
                if (error instanceof IOException) {
                    NIOTransport.this.onException((IOException)error);
                } else {
                    NIOTransport.this.onException(IOExceptionSupport.create(error));
                }
            }
        });
        this.currentBuffer = this.inputBuffer = ByteBuffer.allocate(8192);
        this.nextFrameSize = -1;
        this.currentBuffer.limit(4);
        NIOOutputStream outPutStream = new NIOOutputStream(this.channel, 16384);
        this.dataOut = new DataOutputStream(outPutStream);
        this.buffOut = outPutStream;
    }

    protected void serviceRead() {
        try {
            while (true) {
                int readSize;
                if ((readSize = this.channel.read(this.currentBuffer)) == -1) {
                    this.onException(new EOFException());
                    this.selection.close();
                } else if (readSize != 0) {
                    if (this.currentBuffer.hasRemaining()) continue;
                    if (this.nextFrameSize == -1) {
                        long maxFrameSize;
                        assert (this.inputBuffer == this.currentBuffer);
                        this.inputBuffer.flip();
                        this.nextFrameSize = this.inputBuffer.getInt() + 4;
                        if (this.protocolFormat instanceof BESMPFormat && (long)this.nextFrameSize > (maxFrameSize = ((BESMPFormat)this.protocolFormat).getMaxFrameSize())) {
                            throw new IOException("Frame size of " + this.nextFrameSize / 0x100000 + " MB larger than max allowed " + maxFrameSize / 0x100000L + " MB");
                        }
                        if (this.nextFrameSize > this.inputBuffer.capacity()) {
                            this.currentBuffer = ByteBuffer.allocate(this.nextFrameSize);
                            this.currentBuffer.putInt(this.nextFrameSize);
                            continue;
                        }
                        this.inputBuffer.limit(this.nextFrameSize);
                        continue;
                    }
                    this.currentBuffer.flip();
                    Object command = this.protocolFormat.unmarshal(new DataInputStream(new NIOInputStream(this.currentBuffer)));
                    this.doConsume((Command)command);
                    this.nextFrameSize = -1;
                    this.inputBuffer.clear();
                    this.inputBuffer.limit(4);
                    this.currentBuffer = this.inputBuffer;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (Throwable e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    protected void doStart() throws Exception {
        this.connect();
        this.selection.setInterestOps(1);
        this.selection.enable();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        if (this.selection != null) {
            this.selection.close();
            this.selection = null;
        }
        super.doStop(stopper);
    }

    public String toString() {
        return "tcp://" + this.socket.getInetAddress() + ":" + this.socket.getPort() + "?socketType=nio";
    }
}

