/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.nio;

import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.nio.NIOTransport;
import com.bes.mq.transport.tcp.TcpTransport;
import com.bes.mq.transport.tcp.TcpTransportFactory;
import com.bes.mq.transport.tcp.TcpTransportServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;

public class NIOTransportFactory
extends TcpTransportFactory {
    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new TcpTransportServer(this, location, serverSocketFactory){

            protected Transport createTransport(Socket socket, ProtocolFormat format) throws IOException {
                return new NIOTransport(format, socket);
            }
        };
    }

    protected TcpTransport createTcpTransport(ProtocolFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new NIOTransport(wf, socketFactory, location, localLocation);
    }

    protected ServerSocketFactory createServerSocketFactory() {
        return new ServerSocketFactory(){

            public ServerSocket createServerSocket(int port) throws IOException {
                ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                serverSocketChannel.socket().bind(new InetSocketAddress(port));
                return serverSocketChannel.socket();
            }

            public ServerSocket createServerSocket(int port, int backlog) throws IOException {
                ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                serverSocketChannel.socket().bind(new InetSocketAddress(port), backlog);
                return serverSocketChannel.socket();
            }

            public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
                ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                serverSocketChannel.socket().bind(new InetSocketAddress(ifAddress, port), backlog);
                return serverSocketChannel.socket();
            }
        };
    }

    protected SocketFactory createSocketFactory() throws IOException {
        return new SocketFactory(){

            public Socket createSocket() throws IOException {
                SocketChannel channel = SocketChannel.open();
                return channel.socket();
            }

            public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
                SocketChannel channel = SocketChannel.open();
                channel.connect(new InetSocketAddress(host, port));
                return channel.socket();
            }

            public Socket createSocket(InetAddress address, int port) throws IOException {
                SocketChannel channel = SocketChannel.open();
                channel.connect(new InetSocketAddress(address, port));
                return channel.socket();
            }

            public Socket createSocket(String address, int port, InetAddress localAddresss, int localPort) throws IOException, UnknownHostException {
                SocketChannel channel = SocketChannel.open();
                channel.socket().bind(new InetSocketAddress(localAddresss, localPort));
                channel.connect(new InetSocketAddress(address, port));
                return channel.socket();
            }

            public Socket createSocket(InetAddress address, int port, InetAddress localAddresss, int localPort) throws IOException {
                SocketChannel channel = SocketChannel.open();
                channel.socket().bind(new InetSocketAddress(localAddresss, localPort));
                channel.connect(new InetSocketAddress(address, port));
                return channel.socket();
            }
        };
    }
}

