/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.nio;

import com.bes.mq.transport.nio.SelectorSelection;
import com.bes.mq.transport.nio.SelectorWorker;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class SelectorManager {
    public static final SelectorManager SINGLETON = new SelectorManager();
    private Executor selectorExecutor;
    private Executor channelExecutor;
    private LinkedList<SelectorWorker> freeWorkers;
    private int maxChannelsPerWorker;

    public SelectorManager() {
        this.channelExecutor = this.selectorExecutor = this.createDefaultExecutor();
        this.freeWorkers = new LinkedList();
        this.maxChannelsPerWorker = 1024;
    }

    protected ExecutorService createDefaultExecutor() {
        ThreadPoolExecutor rc = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private long i = 0L;

            public Thread newThread(Runnable runnable) {
                ++this.i;
                Thread t = new Thread(runnable, "BESMQ NIO Worker " + this.i);
                return t;
            }
        });
        return rc;
    }

    public static SelectorManager getInstance() {
        return SINGLETON;
    }

    public synchronized SelectorSelection register(SocketChannel socketChannel, Listener listener) throws IOException {
        SelectorSelection selection = null;
        while (selection == null) {
            SelectorWorker worker;
            if (this.freeWorkers.size() > 0) {
                worker = this.freeWorkers.getFirst();
                if (worker.isReleased()) {
                    this.freeWorkers.remove(worker);
                    continue;
                }
                worker.retain();
                selection = new SelectorSelection(worker, socketChannel, listener);
                continue;
            }
            worker = new SelectorWorker(this);
            this.freeWorkers.addFirst(worker);
            selection = new SelectorSelection(worker, socketChannel, listener);
        }
        return selection;
    }

    synchronized void onWorkerFullEvent(SelectorWorker worker) {
        this.freeWorkers.remove(worker);
    }

    public synchronized void onWorkerEmptyEvent(SelectorWorker worker) {
        this.freeWorkers.remove(worker);
    }

    public synchronized void onWorkerNotFullEvent(SelectorWorker worker) {
        this.freeWorkers.addFirst(worker);
    }

    public Executor getChannelExecutor() {
        return this.channelExecutor;
    }

    public void setChannelExecutor(Executor channelExecutor) {
        this.channelExecutor = channelExecutor;
    }

    public int getMaxChannelsPerWorker() {
        return this.maxChannelsPerWorker;
    }

    public void setMaxChannelsPerWorker(int maxChannelsPerWorker) {
        this.maxChannelsPerWorker = maxChannelsPerWorker;
    }

    public Executor getSelectorExecutor() {
        return this.selectorExecutor;
    }

    public void setSelectorExecutor(Executor selectorExecutor) {
        this.selectorExecutor = selectorExecutor;
    }

    public static interface Listener {
        public void onSelect(SelectorSelection var1);

        public void onError(SelectorSelection var1, Throwable var2);
    }
}

