/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.nio;

import com.bes.mq.transport.nio.SelectorManager;
import com.bes.mq.transport.nio.SelectorWorker;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SelectorSelection {
    private final SelectorWorker worker;
    private final SelectorManager.Listener listener;
    private int interest;
    private SelectionKey key;
    private AtomicBoolean closed = new AtomicBoolean();

    public SelectorSelection(final SelectorWorker worker, final SocketChannel socketChannel, SelectorManager.Listener listener) throws ClosedChannelException {
        this.worker = worker;
        this.listener = listener;
        worker.addIoTask(new Runnable(){

            public void run() {
                try {
                    SelectorSelection.this.key = socketChannel.register(worker.selector, 0, SelectorSelection.this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setInterestOps(int ops) {
        this.interest = ops;
    }

    public void enable() {
        this.worker.addIoTask(new Runnable(){

            public void run() {
                try {
                    SelectorSelection.this.key.interestOps(SelectorSelection.this.interest);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    // empty catch block
                }
            }
        });
    }

    public void disable() {
        this.worker.addIoTask(new Runnable(){

            public void run() {
                try {
                    SelectorSelection.this.key.interestOps(0);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    // empty catch block
                }
            }
        });
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.worker.addIoTask(new Runnable(){

                public void run() {
                    try {
                        SelectorSelection.this.key.cancel();
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        // empty catch block
                    }
                    SelectorSelection.this.worker.release();
                }
            });
        }
    }

    public void onSelect() {
        this.listener.onSelect(this);
    }

    public void onError(Throwable e) {
        this.listener.onError(this, e);
    }
}

