/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.peer;

import com.bes.mq.broker.BrokerFactoryHandler;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.TransportConnector;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFactory;
import com.bes.mq.transport.TransportServer;
import com.bes.mq.transport.vm.VMTransportFactory;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.IdGenerator;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.URISupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class PeerTransportFactory
extends TransportFactory {
    public static final ConcurrentHashMap BROKERS = new ConcurrentHashMap();
    public static final ConcurrentHashMap CONNECTORS = new ConcurrentHashMap();
    public static final ConcurrentHashMap SERVERS = new ConcurrentHashMap();
    private static final IdGenerator ID_GENERATOR = new IdGenerator("peer-");

    public Transport doConnect(URI location) throws Exception {
        VMTransportFactory vmTransportFactory = this.createTransportFactory(location);
        return vmTransportFactory.doConnect(location);
    }

    public Transport doCompositeConnect(URI location) throws Exception {
        VMTransportFactory vmTransportFactory = this.createTransportFactory(location);
        return vmTransportFactory.doCompositeConnect(location);
    }

    private VMTransportFactory createTransportFactory(URI location) throws IOException {
        try {
            HashMap<String, String> brokerOptions;
            String group = location.getHost();
            String broker = URISupport.stripPrefix(location.getPath(), "/");
            if (group == null) {
                group = "default";
            }
            if (broker == null || broker.length() == 0) {
                broker = ID_GENERATOR.generateSanitizedId();
            }
            if (!(brokerOptions = new HashMap<String, String>(URISupport.parseParameters(location))).containsKey("persistent")) {
                brokerOptions.put("persistent", "false");
            }
            final URI finalLocation = new URI("vm://" + broker);
            final String finalBroker = broker;
            final String finalGroup = group;
            VMTransportFactory rc = new VMTransportFactory(){

                public Transport doConnect(URI ignore) throws Exception {
                    return super.doConnect(finalLocation);
                }

                public Transport doCompositeConnect(URI ignore) throws Exception {
                    return super.doCompositeConnect(finalLocation);
                }
            };
            rc.setBrokerFactoryHandler(new BrokerFactoryHandler(){

                public BrokerService createBroker(URI brokerURI) throws Exception {
                    BrokerService service = new BrokerService();
                    IntrospectionSupport.setProperties(service, brokerOptions);
                    service.setBrokerName(finalBroker);
                    TransportConnector c = service.addConnector("tcp://0.0.0.0:0");
                    c.setDiscoveryUri(new URI("multicast://default?group=" + finalGroup));
                    service.addNetworkConnector("multicast://default?group=" + finalGroup);
                    return service;
                }
            });
            return rc;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public TransportServer doBind(URI location) throws IOException {
        throw new IOException("This protocol does not support being bound.");
    }
}

