/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.stomp;

import com.bes.mq.broker.BrokerContext;
import com.bes.mq.broker.BrokerContextAware;
import com.bes.mq.com.thoughtworks.xstream.XStream;
import com.bes.mq.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.bes.mq.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.bes.mq.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.bes.mq.com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.bes.mq.com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.bes.mq.com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.bes.mq.com.thoughtworks.xstream.io.xml.XppReader;
import com.bes.mq.com.thoughtworks.xstream.io.xml.xppdom.XppFactory;
import com.bes.mq.command.BESMQMapMessage;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.BESMQObjectMessage;
import com.bes.mq.command.DataStructure;
import com.bes.mq.org.codehaus.jettison.mapped.Configuration;
import com.bes.mq.protobuf.UTF8Buffer;
import com.bes.mq.transport.stomp.FrameTranslator;
import com.bes.mq.transport.stomp.LegacyFrameTranslator;
import com.bes.mq.transport.stomp.ProtocolConverter;
import com.bes.mq.transport.stomp.ProtocolException;
import com.bes.mq.transport.stomp.Stomp;
import com.bes.mq.transport.stomp.StompFrame;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.jms.JMSException;

public class JmsFrameTranslator
extends LegacyFrameTranslator
implements BrokerContextAware {
    XStream xStream = null;
    BrokerContext brokerContext;

    public BESMQMessage convertFrame(ProtocolConverter converter, StompFrame command) throws JMSException, ProtocolException {
        BESMQMessage msg;
        Map<String, String> headers = command.getHeaders();
        String transformation = headers.get("transformation");
        if (headers.containsKey("content-length") || transformation.equals(Stomp.Transformations.JMS_BYTE.toString())) {
            msg = super.convertFrame(converter, command);
        } else {
            try {
                String text = new String(command.getContent(), "UTF-8");
                switch (Stomp.Transformations.getValue(transformation)) {
                    case JMS_OBJECT_XML: {
                        XppReader in = new XppReader((Reader)new StringReader(text), XppFactory.createDefaultParser());
                        msg = this.createObjectMessage(in);
                        break;
                    }
                    case JMS_OBJECT_JSON: {
                        HierarchicalStreamReader in = new JettisonMappedXmlDriver().createReader(new StringReader(text));
                        msg = this.createObjectMessage(in);
                        break;
                    }
                    case JMS_MAP_XML: {
                        XppReader in = new XppReader((Reader)new StringReader(text), XppFactory.createDefaultParser());
                        msg = this.createMapMessage(in);
                        break;
                    }
                    case JMS_MAP_JSON: {
                        HierarchicalStreamReader in = new JettisonMappedXmlDriver().createReader(new StringReader(text));
                        msg = this.createMapMessage(in);
                        break;
                    }
                    default: {
                        throw new Exception("Unkown transformation: " + transformation);
                    }
                }
            }
            catch (Throwable e) {
                command.getHeaders().put("transformation-error", e.getMessage());
                msg = super.convertFrame(converter, command);
            }
        }
        FrameTranslator.Helper.copyStandardHeadersFromFrameToMessage(converter, command, msg, this);
        return msg;
    }

    public StompFrame convertMessage(ProtocolConverter converter, BESMQMessage message) throws IOException, JMSException {
        if (message.getDataStructureType() == 37) {
            StompFrame command = new StompFrame();
            command.setAction("MESSAGE");
            HashMap<String, String> headers = new HashMap<String, String>(25);
            command.setHeaders(headers);
            FrameTranslator.Helper.copyStandardHeadersFromMessageToFrame(converter, message, command, this);
            if (((String)headers.get("transformation")).equals(Stomp.Transformations.JMS_XML.toString())) {
                headers.put("transformation", Stomp.Transformations.JMS_OBJECT_XML.toString());
            } else if (((String)headers.get("transformation")).equals(Stomp.Transformations.JMS_JSON.toString())) {
                headers.put("transformation", Stomp.Transformations.JMS_OBJECT_JSON.toString());
            }
            BESMQObjectMessage msg = (BESMQObjectMessage)message.copy();
            command.setContent(this.marshall(msg.getObject(), (String)headers.get("transformation")).getBytes("UTF-8"));
            return command;
        }
        if (message.getDataStructureType() == 36) {
            StompFrame command = new StompFrame();
            command.setAction("MESSAGE");
            HashMap<String, String> headers = new HashMap<String, String>(25);
            command.setHeaders(headers);
            FrameTranslator.Helper.copyStandardHeadersFromMessageToFrame(converter, message, command, this);
            if (((String)headers.get("transformation")).equals(Stomp.Transformations.JMS_XML.toString())) {
                headers.put("transformation", Stomp.Transformations.JMS_MAP_XML.toString());
            } else if (((String)headers.get("transformation")).equals(Stomp.Transformations.JMS_JSON.toString())) {
                headers.put("transformation", Stomp.Transformations.JMS_MAP_JSON.toString());
            }
            BESMQMapMessage msg = (BESMQMapMessage)message.copy();
            command.setContent(this.marshall((Serializable)((Object)msg.getContentMap()), (String)headers.get("transformation")).getBytes("UTF-8"));
            return command;
        }
        if (message.getDataStructureType() == 34 && "Notification".equals(message.getType())) {
            StompFrame command = new StompFrame();
            command.setAction("MESSAGE");
            HashMap<String, String> headers = new HashMap<String, String>(25);
            command.setHeaders(headers);
            FrameTranslator.Helper.copyStandardHeadersFromMessageToFrame(converter, message, command, this);
            if (!headers.containsKey("transformation")) {
                headers.put("transformation", Stomp.Transformations.JMS_NOTIFICATION_JSON.toString());
            }
            if (((String)headers.get("transformation")).equals(Stomp.Transformations.JMS_XML.toString())) {
                headers.put("transformation", Stomp.Transformations.JMS_NOTIFICATION_XML.toString());
            } else if (((String)headers.get("transformation")).equals(Stomp.Transformations.JMS_JSON.toString())) {
                headers.put("transformation", Stomp.Transformations.JMS_NOTIFICATION_JSON.toString());
            }
            String body = this.marshallNotification(message.getDataStructure(), (String)headers.get("transformation"));
            command.setContent(body.getBytes("UTF-8"));
            return command;
        }
        return super.convertMessage(converter, message);
    }

    protected String marshall(Serializable object, String transformation) throws JMSException {
        StringWriter buffer = new StringWriter();
        HierarchicalStreamWriter out = transformation.toLowerCase(Locale.ENGLISH).endsWith("json") ? new JettisonMappedXmlDriver(new Configuration(), false).createWriter(buffer) : new PrettyPrintWriter(buffer);
        this.getXStream().marshal(object, out);
        return buffer.toString();
    }

    protected BESMQObjectMessage createObjectMessage(HierarchicalStreamReader in) throws JMSException {
        BESMQObjectMessage objMsg = new BESMQObjectMessage();
        Object obj = this.getXStream().unmarshal(in);
        objMsg.setObject((Serializable)obj);
        return objMsg;
    }

    protected BESMQMapMessage createMapMessage(HierarchicalStreamReader in) throws JMSException {
        BESMQMapMessage mapMsg = new BESMQMapMessage();
        Map map = (Map)this.getXStream().unmarshal(in);
        for (String key : map.keySet()) {
            mapMsg.setObject(key, map.get(key));
        }
        return mapMsg;
    }

    protected String marshallNotification(DataStructure ds, String transformation) {
        StringWriter buffer = new StringWriter();
        HierarchicalStreamWriter out = transformation.toLowerCase(Locale.ENGLISH).endsWith("json") ? new JettisonMappedXmlDriver().createWriter(buffer) : new PrettyPrintWriter(buffer);
        XStream xstream = this.getXStream();
        xstream.setMode(1001);
        xstream.aliasPackage("", "com.bes.mq.command");
        xstream.marshal(ds, out);
        return buffer.toString();
    }

    public XStream getXStream() {
        if (this.xStream == null) {
            this.xStream = this.createXStream();
        }
        return this.xStream;
    }

    public void setXStream(XStream xStream) {
        this.xStream = xStream;
    }

    protected XStream createXStream() {
        XStream xstream = null;
        if (this.brokerContext != null) {
            Map beans = this.brokerContext.getBeansOfType(XStream.class);
            for (XStream bean : beans.values()) {
                if (bean == null) continue;
                xstream = bean;
                break;
            }
        }
        if (xstream == null) {
            xstream = new XStream();
        }
        xstream.registerConverter(new AbstractSingleValueConverter(){

            public Object fromString(String str) {
                return str;
            }

            public boolean canConvert(Class type) {
                return type.equals(UTF8Buffer.class);
            }
        });
        xstream.alias("string", UTF8Buffer.class);
        return xstream;
    }

    public void setBrokerContext(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
    }

    public BrokerContext getBrokerContext() {
        return this.brokerContext;
    }

    protected String marshallNotification(DataStructure ds) {
        XStream xstream = new XStream(new JsonHierarchicalStreamDriver());
        xstream.setMode(1001);
        xstream.aliasPackage("", "com.bes.mq.command");
        return xstream.toXML(ds);
    }
}

