/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.stomp;

import com.bes.mq.command.BESMQBytesMessage;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.BESMQTextMessage;
import com.bes.mq.transport.stomp.FrameTranslator;
import com.bes.mq.transport.stomp.ProtocolConverter;
import com.bes.mq.transport.stomp.ProtocolException;
import com.bes.mq.transport.stomp.StompFrame;
import com.bes.mq.util.ByteArrayOutputStream;
import com.bes.mq.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;

public class LegacyFrameTranslator
implements FrameTranslator {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BESMQMessage convertFrame(ProtocolConverter converter, StompFrame command) throws JMSException, ProtocolException {
        void var4_20;
        Map<String, String> headers = command.getHeaders();
        if (headers.containsKey("bmq-msg-type")) {
            String intendedType = headers.get("bmq-msg-type");
            if (intendedType.equalsIgnoreCase("text")) {
                BESMQTextMessage text = new BESMQTextMessage();
                try {
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream(command.getContent().length + 4);
                    DataOutputStream data = new DataOutputStream(bytes);
                    data.writeInt(command.getContent().length);
                    data.write(command.getContent());
                    text.setContent(bytes.toByteSequence());
                    data.close();
                }
                catch (Throwable e) {
                    throw new ProtocolException("Text could not bet set: " + e, false, e);
                }
                BESMQTextMessage bESMQTextMessage = text;
            } else {
                if (!intendedType.equalsIgnoreCase("bytes")) throw new ProtocolException("Unsupported message type '" + intendedType + "'", false);
                BESMQBytesMessage byteMessage = new BESMQBytesMessage();
                byteMessage.writeBytes(command.getContent());
                BESMQBytesMessage bESMQBytesMessage = byteMessage;
            }
        } else if (headers.containsKey("content-length")) {
            headers.remove("content-length");
            BESMQBytesMessage bm = new BESMQBytesMessage();
            bm.writeBytes(command.getContent());
            BESMQBytesMessage bESMQBytesMessage = bm;
        } else {
            BESMQTextMessage text = new BESMQTextMessage();
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream(command.getContent().length + 4);
                DataOutputStream data = new DataOutputStream(bytes);
                data.writeInt(command.getContent().length);
                data.write(command.getContent());
                text.setContent(bytes.toByteSequence());
                data.close();
            }
            catch (Throwable e) {
                throw new ProtocolException("Text could not bet set: " + e, false, e);
            }
            BESMQTextMessage bESMQTextMessage = text;
        }
        FrameTranslator.Helper.copyStandardHeadersFromFrameToMessage(converter, command, (BESMQMessage)var4_20, this);
        return var4_20;
    }

    public StompFrame convertMessage(ProtocolConverter converter, BESMQMessage message) throws IOException, JMSException {
        StompFrame command = new StompFrame();
        command.setAction("MESSAGE");
        HashMap<String, String> headers = new HashMap<String, String>(25);
        command.setHeaders(headers);
        FrameTranslator.Helper.copyStandardHeadersFromMessageToFrame(converter, message, command, this);
        if (message.getDataStructureType() == 39) {
            if (!message.isCompressed() && message.getContent() != null) {
                ByteSequence msgContent = message.getContent();
                if (msgContent.getLength() > 4) {
                    byte[] content = new byte[msgContent.getLength() - 4];
                    System.arraycopy(msgContent.data, 4, content, 0, content.length);
                    command.setContent(content);
                }
            } else {
                BESMQTextMessage msg = (BESMQTextMessage)message.copy();
                String messageText = msg.getText();
                if (messageText != null) {
                    command.setContent(msg.getText().getBytes("UTF-8"));
                }
            }
        } else if (message.getDataStructureType() == 35) {
            BESMQBytesMessage msg = (BESMQBytesMessage)message.copy();
            msg.setReadOnlyBody(true);
            byte[] data = new byte[(int)msg.getBodyLength()];
            msg.readBytes(data);
            headers.put("content-length", Integer.toString(data.length));
            command.setContent(data);
        }
        return command;
    }

    public String convertDestination(ProtocolConverter converter, Destination d) {
        if (d == null) {
            return null;
        }
        BESMQDestination besMQDestination = (BESMQDestination)d;
        String physicalName = besMQDestination.getPhysicalName();
        String rc = converter.getCreatedTempDestinationName(besMQDestination);
        if (rc != null) {
            return rc;
        }
        StringBuilder buffer = new StringBuilder();
        if (besMQDestination.isQueue()) {
            if (besMQDestination.isTemporary()) {
                buffer.append("/remote-temp-queue/");
            } else {
                buffer.append("/queue/");
            }
        } else if (besMQDestination.isTemporary()) {
            buffer.append("/remote-temp-topic/");
        } else {
            buffer.append("/topic/");
        }
        buffer.append(physicalName);
        return buffer.toString();
    }

    public BESMQDestination convertDestination(ProtocolConverter converter, String name, boolean forceFallback) throws ProtocolException {
        if (name == null) {
            return null;
        }
        String originalName = name;
        if ((name = name.trim()).startsWith("/queue/")) {
            String qName = name.substring("/queue/".length(), name.length());
            return BESMQDestination.createDestination(qName, (byte)1);
        }
        if (name.startsWith("/topic/")) {
            String tName = name.substring("/topic/".length(), name.length());
            return BESMQDestination.createDestination(tName, (byte)2);
        }
        if (name.startsWith("/remote-temp-queue/")) {
            String tName = name.substring("/remote-temp-queue/".length(), name.length());
            return BESMQDestination.createDestination(tName, (byte)5);
        }
        if (name.startsWith("/remote-temp-topic/")) {
            String tName = name.substring("/remote-temp-topic/".length(), name.length());
            return BESMQDestination.createDestination(tName, (byte)6);
        }
        if (name.startsWith("/temp-queue/")) {
            return converter.createTempDestination(name, false);
        }
        if (name.startsWith("/temp-topic/")) {
            return converter.createTempDestination(name, true);
        }
        if (forceFallback) {
            try {
                BESMQDestination fallback = BESMQDestination.getUnresolvableDestinationTransformer().transform(originalName);
                if (fallback != null) {
                    return fallback;
                }
            }
            catch (JMSException e) {
                throw new ProtocolException("Illegal destination name: [" + originalName + "] -- BESMQ STOMP destinations " + "must begin with one of: /queue/ /topic/ /temp-queue/ /temp-topic/", false, e);
            }
        }
        throw new ProtocolException("Illegal destination name: [" + originalName + "] -- BESMQ STOMP destinations " + "must begin with one of: /queue/ /topic/ /temp-queue/ /temp-topic/");
    }
}

