/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.stomp;

import com.bes.mq.broker.BrokerContext;
import com.bes.mq.broker.BrokerContextAware;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.BESMQTempQueue;
import com.bes.mq.command.BESMQTempTopic;
import com.bes.mq.command.Command;
import com.bes.mq.command.ConnectionError;
import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.ConsumerControl;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.DestinationInfo;
import com.bes.mq.command.ExceptionResponse;
import com.bes.mq.command.LocalTransactionId;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.RemoveSubscriptionInfo;
import com.bes.mq.command.Response;
import com.bes.mq.command.SessionId;
import com.bes.mq.command.SessionInfo;
import com.bes.mq.command.ShutdownInfo;
import com.bes.mq.command.TransactionId;
import com.bes.mq.command.TransactionInfo;
import com.bes.mq.common.Version;
import com.bes.mq.notification.NotificationSupport;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.stomp.FrameTranslator;
import com.bes.mq.transport.stomp.JmsFrameTranslator;
import com.bes.mq.transport.stomp.LegacyFrameTranslator;
import com.bes.mq.transport.stomp.ProtocolException;
import com.bes.mq.transport.stomp.ResponseHandler;
import com.bes.mq.transport.stomp.StompCodec;
import com.bes.mq.transport.stomp.StompFrame;
import com.bes.mq.transport.stomp.StompFrameError;
import com.bes.mq.transport.stomp.StompInactivityMonitor;
import com.bes.mq.transport.stomp.StompProtocolFormat;
import com.bes.mq.transport.stomp.StompQueueBrowserSubscription;
import com.bes.mq.transport.stomp.StompSubscription;
import com.bes.mq.transport.stomp.StompTransport;
import com.bes.mq.util.ByteArrayOutputStream;
import com.bes.mq.util.FactoryFinder;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.IdGenerator;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.LongSequenceGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;

public class ProtocolConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolConverter.class);
    private static final IdGenerator CONNECTION_ID_GENERATOR = new IdGenerator();
    private static final String BROKER_VERSION = Version.getPureFullVersion();
    private static final StompFrame ping = new StompFrame("KEEPALIVE");
    private final ConnectionId connectionId = new ConnectionId(CONNECTION_ID_GENERATOR.generateId());
    private final SessionId sessionId = new SessionId(this.connectionId, 1L);
    private final ProducerId producerId = new ProducerId(this.sessionId, 1L);
    private final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator transactionIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator tempDestinationGenerator = new LongSequenceGenerator();
    private final ConcurrentHashMap<Integer, ResponseHandler> resposeHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap<ConsumerId, StompSubscription> subscriptionsByConsumerId = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, StompSubscription> subscriptions = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BESMQDestination> tempDestinations = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> tempDestinationBMQToStompMap = new ConcurrentHashMap();
    private final Map<String, LocalTransactionId> transactions = new ConcurrentHashMap<String, LocalTransactionId>();
    private final StompTransport stompTransport;
    private final ConcurrentHashMap<String, AckEntry> pedingAcks = new ConcurrentHashMap();
    private final IdGenerator ACK_ID_GENERATOR = new IdGenerator();
    private final Object commnadIdMutex = new Object();
    private int lastCommandId;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final FrameTranslator frameTranslator = new LegacyFrameTranslator();
    private final FactoryFinder FRAME_TRANSLATOR_FINDER = new FactoryFinder("META-INF/services/com/bes/mq/transport/frametranslator/");
    private final BrokerContext brokerContext;
    private String version = "1.0";
    private long hbReadInterval;
    private long hbWriteInterval;
    private float hbGracePeriodMultiplier = 1.0f;
    private String defaultHeartBeat = "0,0";
    ConnectionInfo connectionInfo = new ConnectionInfo();

    public ProtocolConverter(StompTransport stompTransport, BrokerContext brokerContext) {
        this.stompTransport = stompTransport;
        this.brokerContext = brokerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int generateCommandId() {
        Object object = this.commnadIdMutex;
        synchronized (object) {
            return this.lastCommandId++;
        }
    }

    protected ResponseHandler createResponseHandler(final StompFrame command) {
        final String receiptId = command.getHeaders().get("receipt");
        if (receiptId != null) {
            return new ResponseHandler(){

                public void onResponse(ProtocolConverter converter, Response response) throws IOException {
                    if (response.isException()) {
                        Throwable exception = ((ExceptionResponse)response).getException();
                        ProtocolConverter.this.handleException(exception, command);
                    } else {
                        StompFrame sc = new StompFrame();
                        sc.setAction("RECEIPT");
                        sc.setHeaders(new HashMap<String, String>(1));
                        sc.getHeaders().put("receipt-id", receiptId);
                        ProtocolConverter.this.stompTransport.sendToStomp(sc);
                    }
                }
            };
        }
        return null;
    }

    protected void sendToBESMQ(Command command, ResponseHandler handler) {
        command.setCommandId(this.generateCommandId());
        if (handler != null) {
            command.setResponseRequired(true);
            this.resposeHandlers.put(command.getCommandId(), handler);
        }
        this.stompTransport.sendToBESMQ(command);
    }

    protected void sendToStomp(StompFrame command) throws IOException {
        this.stompTransport.sendToStomp(command);
    }

    protected FrameTranslator findTranslator(String header) {
        return this.findTranslator(header, null);
    }

    protected FrameTranslator findTranslator(String header, BESMQDestination destination) {
        FrameTranslator translator = this.frameTranslator;
        try {
            if (header != null) {
                translator = (FrameTranslator)this.FRAME_TRANSLATOR_FINDER.newInstance(header);
            } else if (destination != null && NotificationSupport.isNotificationTopic(destination)) {
                translator = new JmsFrameTranslator();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (translator instanceof BrokerContextAware) {
            ((BrokerContextAware)((Object)translator)).setBrokerContext(this.brokerContext);
        }
        return translator;
    }

    public void onStompCommand(StompFrame command) throws IOException, JMSException {
        block13: {
            try {
                if (command.getClass() == StompFrameError.class) {
                    throw ((StompFrameError)command).getException();
                }
                String action = command.getAction();
                if (action.startsWith("SEND")) {
                    this.onStompSend(command);
                    break block13;
                }
                if (action.startsWith("ACK")) {
                    this.onStompAck(command);
                    break block13;
                }
                if (action.startsWith("NACK")) {
                    this.onStompNack(command);
                    break block13;
                }
                if (action.startsWith("BEGIN")) {
                    this.onStompBegin(command);
                    break block13;
                }
                if (action.startsWith("COMMIT")) {
                    this.onStompCommit(command);
                    break block13;
                }
                if (action.startsWith("ABORT")) {
                    this.onStompAbort(command);
                    break block13;
                }
                if (action.startsWith("SUB")) {
                    this.onStompSubscribe(command);
                    break block13;
                }
                if (action.startsWith("UNSUB")) {
                    this.onStompUnsubscribe(command);
                    break block13;
                }
                if (action.startsWith("CONNECT") || action.startsWith("STOMP")) {
                    this.onStompConnect(command);
                    break block13;
                }
                if (action.startsWith("DISCONNECT")) {
                    this.onStompDisconnect(command);
                    break block13;
                }
                throw new ProtocolException("Unknown STOMP action: " + action);
            }
            catch (ProtocolException e) {
                this.handleException(e, command);
                if (!e.isFatal()) break block13;
                this.getStompTransport().onException(e);
            }
        }
    }

    protected void handleException(Throwable exception, StompFrame command) throws IOException {
        String receiptId;
        LOG.warn("Exception occurred processing: \n" + command + ": " + exception.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exception detail", exception);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter stream = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        exception.printStackTrace(stream);
        stream.close();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("message", exception.getMessage());
        headers.put("content-type", "text/plain");
        if (command != null && (receiptId = command.getHeaders().get("receipt")) != null) {
            headers.put("receipt-id", receiptId);
        }
        StompFrame errorMessage = new StompFrame("ERROR", headers, baos.toByteArray());
        this.sendToStomp(errorMessage);
    }

    protected void onStompSend(StompFrame command) throws IOException, JMSException {
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        String destination = headers.get("destination");
        if (destination == null) {
            throw new ProtocolException("SEND received without a Destination specified!");
        }
        String stompTx = headers.get("transaction");
        headers.remove("transaction");
        BESMQMessage message = this.convertMessage(command);
        message.setProducerId(this.producerId);
        MessageId id = new MessageId(this.producerId, this.messageIdGenerator.getNextSequenceId());
        message.setMessageId(id);
        if (stompTx != null) {
            TransactionId besmqTx = this.transactions.get(stompTx);
            if (besmqTx == null) {
                throw new ProtocolException("Invalid transaction id: " + stompTx);
            }
            message.setTransactionId(besmqTx);
        }
        message.onSend();
        this.sendToBESMQ(message, this.createResponseHandler(command));
    }

    protected void onStompNack(StompFrame command) throws ProtocolException {
        MessageAck ack;
        StompSubscription sub;
        this.checkConnected();
        if (this.version.equals("1.0")) {
            throw new ProtocolException("NACK received but connection is in v1.0 mode.");
        }
        Map<String, String> headers = command.getHeaders();
        String subscriptionId = headers.get("subscription");
        if (subscriptionId == null && !this.version.equals("1.2")) {
            throw new ProtocolException("NACK received without a subscription id for acknowledge!");
        }
        String messageId = headers.get("message-id");
        if (messageId == null && !this.version.equals("1.2")) {
            throw new ProtocolException("NACK received without a message id to acknowledge!");
        }
        String ackId = headers.get("id");
        if (ackId == null && this.version.equals("1.2")) {
            throw new ProtocolException("NACK received without an ack header to acknowledge!");
        }
        TransactionId besmqTx = null;
        String stompTx = headers.get("transaction");
        if (stompTx != null && (besmqTx = (TransactionId)this.transactions.get(stompTx)) == null) {
            throw new ProtocolException("Invalid transaction id: " + stompTx);
        }
        boolean nacked = false;
        if (ackId != null) {
            AckEntry pendingAck = this.pedingAcks.get(ackId);
            if (pendingAck != null) {
                messageId = pendingAck.getMessageId();
                MessageAck ack2 = pendingAck.onMessageNack(besmqTx);
                if (ack2 != null) {
                    this.sendToBESMQ(ack2, this.createResponseHandler(command));
                    nacked = true;
                }
            }
        } else if (subscriptionId != null && (sub = this.subscriptions.get(subscriptionId)) != null && (ack = sub.onStompMessageNack(messageId, besmqTx)) != null) {
            this.sendToBESMQ(ack, this.createResponseHandler(command));
            nacked = true;
        }
        if (!nacked) {
            throw new ProtocolException("Unexpected NACK received for message id [" + messageId + "]");
        }
    }

    protected void onStompAck(StompFrame command) throws ProtocolException {
        boolean acked;
        String messageId;
        block8: {
            TransactionId besmqTx;
            block9: {
                MessageAck ack;
                String subscriptionId;
                block7: {
                    this.checkConnected();
                    Map<String, String> headers = command.getHeaders();
                    messageId = headers.get("message-id");
                    if (messageId == null && !this.version.equals("1.2")) {
                        throw new ProtocolException("ACK received without a message-id to acknowledge!");
                    }
                    subscriptionId = headers.get("subscription");
                    if (subscriptionId == null && this.version.equals("1.1")) {
                        throw new ProtocolException("ACK received without a subscription id for acknowledge!");
                    }
                    String ackId = headers.get("id");
                    if (ackId == null && this.version.equals("1.2")) {
                        throw new ProtocolException("ACK received without a ack id for acknowledge!");
                    }
                    besmqTx = null;
                    String stompTx = headers.get("transaction");
                    if (stompTx != null && (besmqTx = (TransactionId)this.transactions.get(stompTx)) == null) {
                        throw new ProtocolException("Invalid transaction id: " + stompTx);
                    }
                    acked = false;
                    if (ackId == null) break block7;
                    AckEntry pendingAck = this.pedingAcks.get(ackId);
                    if (pendingAck == null) break block8;
                    messageId = pendingAck.getMessageId();
                    MessageAck ack2 = pendingAck.onMessageAck(besmqTx);
                    if (ack2 != null) {
                        this.sendToBESMQ(ack2, this.createResponseHandler(command));
                        acked = true;
                    }
                    break block8;
                }
                if (subscriptionId == null) break block9;
                StompSubscription sub = this.subscriptions.get(subscriptionId);
                if (sub == null || (ack = sub.onStompMessageAck(messageId, besmqTx)) == null) break block8;
                this.sendToBESMQ(ack, this.createResponseHandler(command));
                acked = true;
                break block8;
            }
            for (StompSubscription sub : this.subscriptionsByConsumerId.values()) {
                MessageAck ack = sub.onStompMessageAck(messageId, besmqTx);
                if (ack == null) continue;
                this.sendToBESMQ(ack, this.createResponseHandler(command));
                acked = true;
                break;
            }
        }
        if (!acked) {
            throw new ProtocolException("Unexpected ACK received for message id [" + messageId + "]");
        }
    }

    protected void onStompBegin(StompFrame command) throws ProtocolException {
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        String stompTx = headers.get("transaction");
        if (!headers.containsKey("transaction")) {
            throw new ProtocolException("Must specify the transaction you are beginning");
        }
        if (this.transactions.get(stompTx) != null) {
            throw new ProtocolException("The transaction was already started: " + stompTx);
        }
        LocalTransactionId besmqTx = new LocalTransactionId(this.connectionId, this.transactionIdGenerator.getNextSequenceId());
        this.transactions.put(stompTx, besmqTx);
        TransactionInfo tx = new TransactionInfo();
        tx.setConnectionId(this.connectionId);
        tx.setTransactionId(besmqTx);
        tx.setType((byte)0);
        this.sendToBESMQ(tx, this.createResponseHandler(command));
    }

    protected void onStompCommit(StompFrame command) throws ProtocolException {
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        String stompTx = headers.get("transaction");
        if (stompTx == null) {
            throw new ProtocolException("Must specify the transaction you are committing");
        }
        TransactionId besmqTx = this.transactions.remove(stompTx);
        if (besmqTx == null) {
            throw new ProtocolException("Invalid transaction id: " + stompTx);
        }
        for (StompSubscription sub : this.subscriptionsByConsumerId.values()) {
            sub.onStompCommit(besmqTx);
        }
        TransactionInfo tx = new TransactionInfo();
        tx.setConnectionId(this.connectionId);
        tx.setTransactionId(besmqTx);
        tx.setType((byte)2);
        this.sendToBESMQ(tx, this.createResponseHandler(command));
    }

    protected void onStompAbort(StompFrame command) throws ProtocolException {
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        String stompTx = headers.get("transaction");
        if (stompTx == null) {
            throw new ProtocolException("Must specify the transaction you are committing");
        }
        TransactionId besmqTx = this.transactions.remove(stompTx);
        if (besmqTx == null) {
            throw new ProtocolException("Invalid transaction id: " + stompTx);
        }
        for (StompSubscription sub : this.subscriptionsByConsumerId.values()) {
            try {
                sub.onStompAbort(besmqTx);
            }
            catch (Exception e) {
                throw new ProtocolException("Transaction abort failed", false, e);
            }
        }
        TransactionInfo tx = new TransactionInfo();
        tx.setConnectionId(this.connectionId);
        tx.setTransactionId(besmqTx);
        tx.setType((byte)4);
        this.sendToBESMQ(tx, this.createResponseHandler(command));
    }

    protected void onStompSubscribe(StompFrame command) throws ProtocolException {
        String receiptId;
        this.checkConnected();
        FrameTranslator translator = this.findTranslator(command.getHeaders().get("transformation"));
        Map<String, String> headers = command.getHeaders();
        String subscriptionId = headers.get("id");
        String destination = headers.get("destination");
        if (this.version.equals("1.1") && subscriptionId == null) {
            throw new ProtocolException("SUBSCRIBE received without a subscription id!");
        }
        final BESMQDestination actualDest = translator.convertDestination(this, destination, true);
        if (actualDest == null) {
            throw new ProtocolException("Invalid 'null' Destination.");
        }
        final ConsumerId id = new ConsumerId(this.sessionId, this.consumerIdGenerator.getNextSequenceId());
        ConsumerInfo consumerInfo = new ConsumerInfo(id);
        consumerInfo.setPrefetchSize(actualDest.isQueue() ? 1000 : (headers.containsKey("besmq.subscriptionName") ? 100 : Short.MAX_VALUE));
        consumerInfo.setDispatchAsync(true);
        String browser = headers.get("browser");
        if (browser != null && browser.equals("true")) {
            if (this.version.equals("1.0")) {
                throw new ProtocolException("Queue Browser feature only valid for Stomp v1.1+ clients!");
            }
            consumerInfo.setBrowser(true);
            consumerInfo.setPrefetchSize(500);
        }
        String selector = headers.remove("selector");
        consumerInfo.setSelector(selector);
        IntrospectionSupport.setProperties(consumerInfo, headers, "besmq.");
        if (actualDest.isQueue() && consumerInfo.getSubscriptionName() != null) {
            throw new ProtocolException("Invalid Subscription: cannot durably subscribe to a Queue destination!");
        }
        consumerInfo.setDestination(translator.convertDestination(this, destination, true));
        StompSubscription stompSubscription = !consumerInfo.isBrowser() ? new StompSubscription(this, subscriptionId, consumerInfo, headers.get("transformation")) : new StompQueueBrowserSubscription(this, subscriptionId, consumerInfo, headers.get("transformation"));
        stompSubscription.setDestination(actualDest);
        String ackMode = headers.get("ack");
        if ("client".equals(ackMode)) {
            stompSubscription.setAckMode("client");
        } else if ("client-individual".equals(ackMode)) {
            stompSubscription.setAckMode("client-individual");
        } else {
            stompSubscription.setAckMode("auto");
        }
        this.subscriptionsByConsumerId.put(id, stompSubscription);
        if (subscriptionId != null) {
            this.subscriptions.put(subscriptionId, stompSubscription);
        }
        if ((receiptId = command.getHeaders().get("receipt")) != null && consumerInfo.getPrefetchSize() > 0) {
            final StompFrame cmd = command;
            final int prefetch = consumerInfo.getPrefetchSize();
            consumerInfo.setPrefetchSize(0);
            ResponseHandler handler = new ResponseHandler(){

                public void onResponse(ProtocolConverter converter, Response response) throws IOException {
                    if (response.isException()) {
                        Throwable exception = ((ExceptionResponse)response).getException();
                        ProtocolConverter.this.handleException(exception, cmd);
                    } else {
                        StompFrame sc = new StompFrame();
                        sc.setAction("RECEIPT");
                        sc.setHeaders(new HashMap<String, String>(1));
                        sc.getHeaders().put("receipt-id", receiptId);
                        ProtocolConverter.this.stompTransport.sendToStomp(sc);
                        ConsumerControl control = new ConsumerControl();
                        control.setPrefetch(prefetch);
                        control.setDestination(actualDest);
                        control.setConsumerId(id);
                        ProtocolConverter.this.sendToBESMQ(control, null);
                    }
                }
            };
            this.sendToBESMQ(consumerInfo, handler);
        } else {
            this.sendToBESMQ(consumerInfo, this.createResponseHandler(command));
        }
    }

    protected void onStompUnsubscribe(StompFrame command) throws ProtocolException {
        String durable;
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        BESMQDestination destination = null;
        String o = headers.get("destination");
        if (o != null) {
            destination = this.findTranslator(command.getHeaders().get("transformation")).convertDestination(this, o, true);
        }
        String subscriptionId = headers.get("id");
        if (this.version.equals("1.1") && subscriptionId == null) {
            throw new ProtocolException("UNSUBSCRIBE received without a subscription id!");
        }
        if (subscriptionId == null && destination == null) {
            throw new ProtocolException("Must specify the subscriptionId or the destination you are unsubscribing from");
        }
        String clientId = durable = command.getHeaders().get("besmq.subscriptionName");
        if (this.version.equals("1.1")) {
            clientId = this.connectionInfo.getClientId();
        }
        if (durable != null) {
            RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
            info.setClientId(clientId);
            info.setSubscriptionName(durable);
            info.setConnectionId(this.connectionId);
            this.sendToBESMQ(info, this.createResponseHandler(command));
            return;
        }
        if (subscriptionId != null) {
            StompSubscription sub = this.subscriptions.remove(subscriptionId);
            if (sub != null) {
                this.sendToBESMQ(sub.getConsumerInfo().createRemoveCommand(), this.createResponseHandler(command));
                return;
            }
        } else {
            Iterator<StompSubscription> iter = this.subscriptionsByConsumerId.values().iterator();
            while (iter.hasNext()) {
                StompSubscription sub = iter.next();
                if (destination == null || !destination.equals(sub.getDestination())) continue;
                this.sendToBESMQ(sub.getConsumerInfo().createRemoveCommand(), this.createResponseHandler(command));
                iter.remove();
                return;
            }
        }
        throw new ProtocolException("No subscription matched.");
    }

    protected void onStompConnect(final StompFrame command) throws ProtocolException {
        if (this.connected.get()) {
            throw new ProtocolException("Already connected.");
        }
        final Map<String, String> headers = command.getHeaders();
        String login = headers.get("login");
        String passcode = headers.get("passcode");
        String clientId = headers.get("client-id");
        String heartBeat = headers.get("heart-beat");
        if (heartBeat == null) {
            heartBeat = this.defaultHeartBeat;
        }
        this.version = StompCodec.detectVersion(headers);
        this.configureInactivityMonitor(heartBeat.trim());
        IntrospectionSupport.setProperties(this.connectionInfo, headers, "besmq.");
        this.connectionInfo.setConnectionId(this.connectionId);
        if (clientId != null) {
            this.connectionInfo.setClientId(clientId);
        } else {
            this.connectionInfo.setClientId("" + this.connectionInfo.getConnectionId().toString());
        }
        this.connectionInfo.setResponseRequired(true);
        this.connectionInfo.setUserName(login);
        this.connectionInfo.setPassword(passcode);
        this.connectionInfo.setTransportContext(command.getTransportContext());
        this.sendToBESMQ(this.connectionInfo, new ResponseHandler(){

            public void onResponse(ProtocolConverter converter, Response response) throws IOException {
                if (response.isException()) {
                    Throwable exception = ((ExceptionResponse)response).getException();
                    ProtocolConverter.this.handleException(exception, command);
                    ProtocolConverter.this.getStompTransport().onException(IOExceptionSupport.create(exception));
                    return;
                }
                SessionInfo sessionInfo = new SessionInfo(ProtocolConverter.this.sessionId);
                ProtocolConverter.this.sendToBESMQ(sessionInfo, null);
                ProducerInfo producerInfo = new ProducerInfo(ProtocolConverter.this.producerId);
                ProtocolConverter.this.sendToBESMQ(producerInfo, new ResponseHandler(){

                    public void onResponse(ProtocolConverter converter, Response response) throws IOException {
                        if (response.isException()) {
                            Throwable exception = ((ExceptionResponse)response).getException();
                            ProtocolConverter.this.handleException(exception, command);
                            ProtocolConverter.this.getStompTransport().onException(IOExceptionSupport.create(exception));
                        }
                        ProtocolConverter.this.connected.set(true);
                        HashMap<String, String> responseHeaders = new HashMap<String, String>();
                        responseHeaders.put("session", ProtocolConverter.this.connectionInfo.getClientId());
                        String requestId = (String)headers.get("request-id");
                        if (requestId == null) {
                            requestId = (String)headers.get("receipt");
                        }
                        if (requestId != null) {
                            responseHeaders.put("response-id", requestId);
                            responseHeaders.put("receipt-id", requestId);
                        }
                        responseHeaders.put("version", ProtocolConverter.this.version);
                        responseHeaders.put("heart-beat", String.format("%d,%d", ProtocolConverter.this.hbWriteInterval, ProtocolConverter.this.hbReadInterval));
                        responseHeaders.put("server", "BESMQ/" + BROKER_VERSION);
                        StompFrame sc = new StompFrame();
                        sc.setAction("CONNECTED");
                        sc.setHeaders(responseHeaders);
                        ProtocolConverter.this.sendToStomp(sc);
                        StompProtocolFormat format = ProtocolConverter.this.stompTransport.getProtocolFormat();
                        if (format != null) {
                            format.setStompVersion(ProtocolConverter.this.version);
                        }
                    }
                });
            }
        });
    }

    protected void onStompDisconnect(StompFrame command) throws ProtocolException {
        if (this.connected.get()) {
            this.sendToBESMQ(this.connectionInfo.createRemoveCommand(), this.createResponseHandler(command));
            this.sendToBESMQ(new ShutdownInfo(), this.createResponseHandler(command));
            this.connected.set(false);
        }
    }

    protected void checkConnected() throws ProtocolException {
        if (!this.connected.get()) {
            throw new ProtocolException("Not connected.");
        }
    }

    public void onBESMQCommand(Command command) throws IOException, JMSException {
        if (command.isResponse()) {
            Response response = (Response)command;
            ResponseHandler rh = this.resposeHandlers.remove(response.getCorrelationId());
            if (rh != null) {
                rh.onResponse(this, response);
            } else if (response.isException()) {
                Throwable exception = ((ExceptionResponse)response).getException();
                this.handleException(exception, null);
            }
        } else if (command.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)command;
            StompSubscription sub = this.subscriptionsByConsumerId.get(md.getConsumerId());
            if (sub != null) {
                String ackId = null;
                if (this.version.equals("1.2") && sub.getAckMode() != "auto" && md.getMessage() != null) {
                    AckEntry pendingAck = new AckEntry(md.getMessage().getMessageId().toString(), sub);
                    ackId = this.ACK_ID_GENERATOR.generateId();
                    this.pedingAcks.put(ackId, pendingAck);
                }
                try {
                    sub.onMessageDispatch(md, ackId);
                }
                catch (Exception ex) {
                    if (ackId != null) {
                        this.pedingAcks.remove(ackId);
                    }
                }
            }
        } else if (command.getDataStructureType() == 14) {
            this.stompTransport.sendToStomp(ping);
        } else if (command.getDataStructureType() == 11) {
            Throwable exception = ((ConnectionError)command).getException();
            this.handleException(exception, null);
        }
    }

    public BESMQMessage convertMessage(StompFrame command) throws IOException, JMSException {
        BESMQMessage msg = this.findTranslator(command.getHeaders().get("transformation")).convertFrame(this, command);
        return msg;
    }

    public StompFrame convertMessage(BESMQMessage message, boolean ignoreTransformation) throws IOException, JMSException {
        if (ignoreTransformation) {
            return this.frameTranslator.convertMessage(this, message);
        }
        return this.findTranslator(message.getStringProperty("transformation"), message.getDestination()).convertMessage(this, message);
    }

    public StompTransport getStompTransport() {
        return this.stompTransport;
    }

    public BESMQDestination createTempDestination(String name, boolean topic) {
        BESMQDestination rc = this.tempDestinations.get(name);
        if (rc == null) {
            rc = topic ? new BESMQTempTopic(this.connectionId, this.tempDestinationGenerator.getNextSequenceId()) : new BESMQTempQueue(this.connectionId, this.tempDestinationGenerator.getNextSequenceId());
            this.sendToBESMQ(new DestinationInfo(this.connectionId, 0, rc), null);
            this.tempDestinations.put(name, rc);
            this.tempDestinationBMQToStompMap.put(rc.getQualifiedName(), name);
        }
        return rc;
    }

    public String getCreatedTempDestinationName(BESMQDestination destination) {
        return this.tempDestinationBMQToStompMap.get(destination.getQualifiedName());
    }

    public String getDefaultHeartBeat() {
        return this.defaultHeartBeat;
    }

    public void setDefaultHeartBeat(String defaultHeartBeat) {
        this.defaultHeartBeat = defaultHeartBeat;
    }

    public float getHbGracePeriodMultiplier() {
        return this.hbGracePeriodMultiplier;
    }

    public void setHbGracePeriodMultiplier(float hbGracePeriodMultiplier) {
        this.hbGracePeriodMultiplier = hbGracePeriodMultiplier;
    }

    protected void configureInactivityMonitor(String heartBeatConfig) throws ProtocolException {
        String[] keepAliveOpts = heartBeatConfig.split(",");
        if (keepAliveOpts == null || keepAliveOpts.length != 2) {
            throw new ProtocolException("Invalid heart-beat header:" + heartBeatConfig, true);
        }
        try {
            this.hbReadInterval = Long.parseLong(keepAliveOpts[0]);
            this.hbWriteInterval = Long.parseLong(keepAliveOpts[1]);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Invalid heart-beat header:" + heartBeatConfig, true);
        }
        try {
            StompInactivityMonitor monitor = this.stompTransport.getInactivityMonitor();
            monitor.setReadCheckTime((long)((float)this.hbReadInterval * this.hbGracePeriodMultiplier));
            monitor.setReadCheckTime(this.hbReadInterval);
            monitor.setInitialDelayTime(Math.min(this.hbReadInterval, this.hbWriteInterval));
            monitor.setWriteCheckTime(this.hbWriteInterval);
            monitor.startMonitoring();
        }
        catch (Exception ex) {
            this.hbReadInterval = 0L;
            this.hbWriteInterval = 0L;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stomp Connect heartbeat conf RW[" + this.hbReadInterval + "," + this.hbWriteInterval + "]");
        }
    }

    protected void sendReceipt(StompFrame command) {
        String receiptId = command.getHeaders().get("receipt");
        if (receiptId != null) {
            StompFrame sc = new StompFrame();
            sc.setAction("RECEIPT");
            sc.setHeaders(new HashMap<String, String>(1));
            sc.getHeaders().put("receipt-id", receiptId);
            try {
                this.sendToStomp(sc);
            }
            catch (IOException e) {
                LOG.warn("Could not send a receipt for " + command, e);
            }
        }
    }

    private static class AckEntry {
        private final String messageId;
        private final StompSubscription subscription;

        public AckEntry(String messageId, StompSubscription subscription) {
            this.messageId = messageId;
            this.subscription = subscription;
        }

        public MessageAck onMessageAck(TransactionId transactionId) {
            return this.subscription.onStompMessageAck(this.messageId, transactionId);
        }

        public MessageAck onMessageNack(TransactionId transactionId) throws ProtocolException {
            return this.subscription.onStompMessageNack(this.messageId, transactionId);
        }

        public String getMessageId() {
            return this.messageId;
        }

        public StompSubscription getSubscription() {
            return this.subscription;
        }
    }
}

