/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.stomp;

import com.bes.mq.transport.stomp.ProtocolException;
import com.bes.mq.transport.stomp.Stomp;
import com.bes.mq.transport.stomp.StompFrame;
import com.bes.mq.transport.stomp.StompProtocolFormat;
import com.bes.mq.transport.tcp.TcpTransport;
import com.bes.mq.util.ByteArrayOutputStream;
import com.bes.mq.util.DataByteArrayInputStream;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StompCodec {
    static final byte[] crlfcrlf = new byte[]{13, 10, 13, 10};
    TcpTransport transport;
    ByteArrayOutputStream currentCommand = new ByteArrayOutputStream();
    boolean processedHeaders = false;
    String action;
    HashMap<String, String> headers;
    int contentLength = -1;
    int readLength = 0;
    int previousByte = -1;
    boolean awaitingCommandStart = true;
    String version = "1.0";

    public StompCodec(TcpTransport transport) {
        this.transport = transport;
    }

    public void parse(ByteArrayInputStream input, int readSize) throws Exception {
        int i = 0;
        while (i++ < readSize) {
            int b = input.read();
            if (!this.processedHeaders && this.previousByte == 0 && b == 0) continue;
            if (!this.processedHeaders) {
                if (this.awaitingCommandStart && b == 10) continue;
                this.awaitingCommandStart = false;
                this.currentCommand.write(b);
                if (b == 10 && (this.previousByte == 10 || this.currentCommand.endsWith(crlfcrlf))) {
                    StompProtocolFormat wf = (StompProtocolFormat)this.transport.getProtocolFormat();
                    DataByteArrayInputStream data = new DataByteArrayInputStream(this.currentCommand.toByteArray());
                    this.action = wf.parseAction(data);
                    this.headers = wf.parseHeaders(data);
                    try {
                        String contentLengthHeader = this.headers.get("content-length");
                        this.contentLength = (this.action.equals("SEND") || this.action.equals("MESSAGE")) && contentLengthHeader != null ? wf.parseContentLength(contentLengthHeader) : -1;
                    }
                    catch (ProtocolException ignore) {
                        // empty catch block
                    }
                    this.processedHeaders = true;
                    this.currentCommand.reset();
                }
            } else if (this.contentLength == -1) {
                if (b == 0) {
                    this.processCommand();
                } else {
                    this.currentCommand.write(b);
                }
            } else if (this.readLength++ == this.contentLength) {
                this.processCommand();
                this.readLength = 0;
            } else {
                this.currentCommand.write(b);
            }
            this.previousByte = b;
        }
    }

    protected void processCommand() throws Exception {
        StompFrame frame = new StompFrame(this.action, this.headers, this.currentCommand.toByteArray());
        this.transport.doConsume(frame);
        this.processedHeaders = false;
        this.awaitingCommandStart = true;
        this.currentCommand.reset();
        this.contentLength = -1;
    }

    public static String detectVersion(Map<String, String> headers) throws ProtocolException {
        String accepts = headers.get("accept-version");
        if (accepts == null) {
            accepts = "1.0";
        }
        HashSet<String> acceptsVersions = new HashSet<String>(Arrays.asList(accepts.trim().split(",")));
        acceptsVersions.retainAll(Arrays.asList(Stomp.SUPPORTED_PROTOCOL_VERSIONS));
        if (acceptsVersions.isEmpty()) {
            throw new ProtocolException("Invalid Protocol version[" + accepts + "], supported versions are: " + Arrays.toString(Stomp.SUPPORTED_PROTOCOL_VERSIONS), true);
        }
        return Collections.max(acceptsVersions);
    }
}

