/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.stomp;

import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.nio.NIOSSLTransport;
import com.bes.mq.transport.stomp.StompCodec;
import com.bes.mq.transport.stomp.StompFrame;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;

public class StompNIOSSLTransport
extends NIOSSLTransport {
    StompCodec codec;
    private X509Certificate[] cachedPeerCerts;

    public StompNIOSSLTransport(ProtocolFormat protocolFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        super(protocolFormat, socketFactory, remoteLocation, localLocation);
    }

    public StompNIOSSLTransport(ProtocolFormat protocolFormat, Socket socket) throws IOException {
        super(protocolFormat, socket);
    }

    protected void initializeStreams() throws IOException {
        this.codec = new StompCodec(this);
        super.initializeStreams();
        if (this.inputBuffer.position() != 0 && this.inputBuffer.hasRemaining()) {
            this.serviceRead();
        }
    }

    protected void processCommand(ByteBuffer plain) throws Exception {
        byte[] fill = new byte[plain.remaining()];
        plain.get(fill);
        ByteArrayInputStream input = new ByteArrayInputStream(fill);
        this.codec.parse(input, fill.length);
    }

    public void doConsume(Object command) {
        StompFrame frame = (StompFrame)command;
        if (this.cachedPeerCerts == null) {
            this.cachedPeerCerts = this.getPeerCertificates();
        }
        frame.setTransportContext(this.cachedPeerCerts);
        super.doConsume(command);
    }
}

