/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.stomp;

import com.bes.mq.broker.SslContext;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportServer;
import com.bes.mq.transport.nio.NIOSSLTransportServer;
import com.bes.mq.transport.stomp.StompNIOSSLTransport;
import com.bes.mq.transport.stomp.StompNIOTransportFactory;
import com.bes.mq.transport.tcp.TcpTransport;
import com.bes.mq.transport.tcp.TcpTransportServer;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;

public class StompNIOSSLTransportFactory
extends StompNIOTransportFactory {
    protected SSLContext context;

    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new NIOSSLTransportServer(this.context, this, location, serverSocketFactory){

            protected Transport createTransport(Socket socket, ProtocolFormat format) throws IOException {
                StompNIOSSLTransport transport = new StompNIOSSLTransport(format, socket);
                if (StompNIOSSLTransportFactory.this.context != null) {
                    transport.setSslContext(StompNIOSSLTransportFactory.this.context);
                }
                transport.setNeedClientAuth(this.isNeedClientAuth());
                transport.setWantClientAuth(this.isWantClientAuth());
                return transport;
            }
        };
    }

    protected TcpTransport createTcpTransport(ProtocolFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new StompNIOSSLTransport(wf, socketFactory, location, localLocation);
    }

    public TransportServer doBind(URI location) throws IOException {
        if (SslContext.getCurrentSslContext() != null) {
            try {
                this.context = SslContext.getCurrentSslContext().getSSLContext();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return super.doBind(location);
    }
}

