/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.stomp;

import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.nio.NIOOutputStream;
import com.bes.mq.transport.nio.SelectorManager;
import com.bes.mq.transport.nio.SelectorSelection;
import com.bes.mq.transport.stomp.StompCodec;
import com.bes.mq.transport.tcp.TcpTransport;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.ServiceStopper;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.SocketFactory;

public class StompNIOTransport
extends TcpTransport {
    private SocketChannel channel;
    private SelectorSelection selection;
    private ByteBuffer inputBuffer;
    StompCodec codec;

    public StompNIOTransport(ProtocolFormat protocolFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        super(protocolFormat, socketFactory, remoteLocation, localLocation);
    }

    public StompNIOTransport(ProtocolFormat protocolFormat, Socket socket) throws IOException {
        super(protocolFormat, socket);
    }

    protected void initializeStreams() throws IOException {
        this.channel = this.socket.getChannel();
        this.channel.configureBlocking(false);
        this.selection = SelectorManager.getInstance().register(this.channel, new SelectorManager.Listener(){

            public void onSelect(SelectorSelection selection) {
                StompNIOTransport.this.serviceRead();
            }

            public void onError(SelectorSelection selection, Throwable error) {
                if (error instanceof IOException) {
                    StompNIOTransport.this.onException((IOException)error);
                } else {
                    StompNIOTransport.this.onException(IOExceptionSupport.create(error));
                }
            }
        });
        this.inputBuffer = ByteBuffer.allocate(8192);
        NIOOutputStream outPutStream = new NIOOutputStream(this.channel, 8192);
        this.dataOut = new DataOutputStream(outPutStream);
        this.buffOut = outPutStream;
        this.codec = new StompCodec(this);
    }

    private void serviceRead() {
        try {
            while (true) {
                int readSize;
                if ((readSize = this.channel.read(this.inputBuffer)) == -1) {
                    this.onException(new EOFException());
                    this.selection.close();
                } else if (readSize != 0) {
                    this.receiveCounter += readSize;
                    this.inputBuffer.flip();
                    ByteArrayInputStream input = new ByteArrayInputStream(this.inputBuffer.array());
                    this.codec.parse(input, readSize);
                    this.inputBuffer.clear();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (Throwable e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    protected void doStart() throws Exception {
        this.connect();
        this.selection.setInterestOps(1);
        this.selection.enable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop(ServiceStopper stopper) throws Exception {
        try {
            if (this.selection != null) {
                this.selection.close();
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.doStop(stopper);
            throw throwable;
        }
        super.doStop(stopper);
    }
}

