/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.stomp;

import com.bes.mq.broker.BrokerContext;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.BrokerServiceAware;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.MutexTransport;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.nio.NIOTransportFactory;
import com.bes.mq.transport.stomp.StompInactivityMonitor;
import com.bes.mq.transport.stomp.StompNIOTransport;
import com.bes.mq.transport.stomp.StompTransportFilter;
import com.bes.mq.transport.tcp.TcpTransport;
import com.bes.mq.transport.tcp.TcpTransportServer;
import com.bes.mq.util.IntrospectionSupport;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;

public class StompNIOTransportFactory
extends NIOTransportFactory
implements BrokerServiceAware {
    private BrokerContext brokerContext = null;

    protected String getDefaultProtocolFormatType() {
        return "stomp";
    }

    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new TcpTransportServer(this, location, serverSocketFactory){

            protected Transport createTransport(Socket socket, ProtocolFormat format) throws IOException {
                return new StompNIOTransport(format, socket);
            }
        };
    }

    protected TcpTransport createTcpTransport(ProtocolFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new StompNIOTransport(wf, socketFactory, location, localLocation);
    }

    public Transport serverConfigure(Transport transport, ProtocolFormat format, HashMap options) throws Exception {
        MutexTransport mutex = (transport = super.serverConfigure(transport, format, options)).narrow(MutexTransport.class);
        if (mutex != null) {
            mutex.setSyncOnCommand(true);
        }
        return transport;
    }

    public Transport compositeConfigure(Transport transport, ProtocolFormat format, Map options) {
        transport = new StompTransportFilter(transport, format, this.brokerContext);
        IntrospectionSupport.setProperties(transport, options);
        return super.compositeConfigure(transport, format, options);
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerContext = brokerService.getBrokerContext();
    }

    protected Transport createInactivityMonitor(Transport transport, ProtocolFormat format) {
        StompInactivityMonitor monitor = new StompInactivityMonitor(transport, format);
        StompTransportFilter filter = transport.narrow(StompTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

