/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.stomp;

import com.bes.mq.broker.BrokerContext;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.BrokerServiceAware;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.MutexTransport;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.stomp.StompFrame;
import com.bes.mq.transport.stomp.StompInactivityMonitor;
import com.bes.mq.transport.stomp.StompTransportFilter;
import com.bes.mq.transport.tcp.SslTransport;
import com.bes.mq.transport.tcp.SslTransportFactory;
import com.bes.mq.transport.tcp.SslTransportServer;
import com.bes.mq.util.IntrospectionSupport;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

public class StompSslTransportFactory
extends SslTransportFactory
implements BrokerServiceAware {
    private BrokerContext brokerContext = null;

    protected String getDefaultProtocolFormatType() {
        return "stomp";
    }

    protected SslTransportServer createSslTransportServer(URI location, SSLServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new SslTransportServer(this, location, serverSocketFactory){

            protected Transport createTransport(Socket socket, ProtocolFormat format) throws IOException {
                return new SslTransport(format, (SSLSocket)socket){
                    private X509Certificate[] cachedPeerCerts;

                    public void doConsume(Object command) {
                        StompFrame frame = (StompFrame)command;
                        if (this.cachedPeerCerts == null) {
                            this.cachedPeerCerts = this.getPeerCertificates();
                        }
                        frame.setTransportContext(this.cachedPeerCerts);
                        super.doConsume(command);
                    }
                };
            }
        };
    }

    public Transport compositeConfigure(Transport transport, ProtocolFormat format, Map options) {
        transport = new StompTransportFilter(transport, format, this.brokerContext);
        IntrospectionSupport.setProperties(transport, options);
        return super.compositeConfigure(transport, format, options);
    }

    public Transport serverConfigure(Transport transport, ProtocolFormat format, HashMap options) throws Exception {
        MutexTransport mutex = (transport = super.serverConfigure(transport, format, options)).narrow(MutexTransport.class);
        if (mutex != null) {
            mutex.setSyncOnCommand(true);
        }
        return transport;
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerContext = brokerService.getBrokerContext();
    }

    protected Transport createInactivityMonitor(Transport transport, ProtocolFormat format) {
        StompInactivityMonitor monitor = new StompInactivityMonitor(transport, format);
        StompTransportFilter filter = transport.narrow(StompTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

