/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.stomp;

import com.bes.mq.broker.BrokerContext;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.BrokerServiceAware;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.MutexTransport;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.stomp.StompInactivityMonitor;
import com.bes.mq.transport.stomp.StompTransportFilter;
import com.bes.mq.transport.tcp.TcpTransportFactory;
import com.bes.mq.util.IntrospectionSupport;
import java.util.HashMap;
import java.util.Map;

public class StompTransportFactory
extends TcpTransportFactory
implements BrokerServiceAware {
    private BrokerContext brokerContext = null;

    protected String getDefaultProtocolFormatType() {
        return "stomp";
    }

    public Transport compositeConfigure(Transport transport, ProtocolFormat format, Map options) {
        transport = new StompTransportFilter(transport, format, this.brokerContext);
        IntrospectionSupport.setProperties(transport, options);
        return super.compositeConfigure(transport, format, options);
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerContext = brokerService.getBrokerContext();
    }

    public Transport serverConfigure(Transport transport, ProtocolFormat format, HashMap options) throws Exception {
        MutexTransport mutex = (transport = super.serverConfigure(transport, format, options)).narrow(MutexTransport.class);
        if (mutex != null) {
            mutex.setSyncOnCommand(true);
        }
        return transport;
    }

    protected Transport createInactivityMonitor(Transport transport, ProtocolFormat format) {
        StompInactivityMonitor monitor = new StompInactivityMonitor(transport, format);
        StompTransportFilter filter = transport.narrow(StompTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

