/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.stomp;

import com.bes.mq.broker.BrokerContext;
import com.bes.mq.command.Command;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFilter;
import com.bes.mq.transport.TransportListener;
import com.bes.mq.transport.stomp.ProtocolConverter;
import com.bes.mq.transport.stomp.StompFrame;
import com.bes.mq.transport.stomp.StompInactivityMonitor;
import com.bes.mq.transport.stomp.StompProtocolFormat;
import com.bes.mq.transport.stomp.StompTransport;
import com.bes.mq.util.IOExceptionSupport;
import java.io.IOException;
import javax.jms.JMSException;

public class StompTransportFilter
extends TransportFilter
implements StompTransport {
    private static final Logger TRACE = LoggerFactory.getLogger(StompTransportFilter.class.getPackage().getName() + ".StompIO");
    private final ProtocolConverter protocolConverter;
    private StompInactivityMonitor monitor;
    private StompProtocolFormat protocolFormat;
    private boolean trace;

    public StompTransportFilter(Transport next, ProtocolFormat protocolFormat, BrokerContext brokerContext) {
        super(next);
        this.protocolConverter = new ProtocolConverter(this, brokerContext);
        if (protocolFormat instanceof StompProtocolFormat) {
            this.protocolFormat = (StompProtocolFormat)protocolFormat;
        }
    }

    public void oneway(Object o) throws IOException {
        try {
            Command command = (Command)o;
            this.protocolConverter.onBESMQCommand(command);
        }
        catch (JMSException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public void onCommand(Object command) {
        try {
            if (this.trace) {
                TRACE.trace("Received: \n" + command);
            }
            this.protocolConverter.onStompCommand((StompFrame)command);
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (JMSException e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    public void sendToBESMQ(Command command) {
        TransportListener l = this.transportListener;
        if (l != null) {
            l.onCommand(command);
        }
    }

    public void sendToStomp(StompFrame command) throws IOException {
        Transport n;
        if (this.trace) {
            TRACE.trace("Sending: \n" + command);
        }
        if ((n = this.next) != null) {
            n.oneway(command);
        }
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public StompInactivityMonitor getInactivityMonitor() {
        return this.monitor;
    }

    public void setInactivityMonitor(StompInactivityMonitor monitor) {
        this.monitor = monitor;
    }

    public StompProtocolFormat getProtocolFormat() {
        return this.protocolFormat;
    }

    public String getDefaultHeartBeat() {
        return this.protocolConverter != null ? this.protocolConverter.getDefaultHeartBeat() : null;
    }

    public void setDefaultHeartBeat(String defaultHeartBeat) {
        this.protocolConverter.setDefaultHeartBeat(defaultHeartBeat);
    }

    public float getHbGracePeriodMultiplier() {
        return (this.protocolConverter != null ? Float.valueOf(this.protocolConverter.getHbGracePeriodMultiplier()) : null).floatValue();
    }

    public void setHbGracePeriodMultiplier(float hbGracePeriodMultiplier) {
        if (hbGracePeriodMultiplier > 1.0f) {
            this.protocolConverter.setHbGracePeriodMultiplier(hbGracePeriodMultiplier);
        }
    }
}

