/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.tcp;

import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.tcp.TcpTransport;
import java.io.IOException;
import java.net.URI;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SslTransport
extends TcpTransport {
    public SslTransport(ProtocolFormat protocolFormat, SSLSocketFactory socketFactory, URI remoteLocation, URI localLocation, boolean needClientAuth) throws IOException {
        super(protocolFormat, socketFactory, remoteLocation, localLocation);
        if (this.socket != null) {
            ((SSLSocket)this.socket).setNeedClientAuth(needClientAuth);
        }
    }

    public SslTransport(ProtocolFormat protocolFormat, SSLSocket socket) throws IOException {
        super(protocolFormat, socket);
    }

    public void doConsume(Object command) {
        if (command instanceof ConnectionInfo) {
            ConnectionInfo connectionInfo = (ConnectionInfo)command;
            connectionInfo.setTransportContext(this.getPeerCertificates());
        }
        super.doConsume(command);
    }

    public X509Certificate[] getPeerCertificates() {
        X509Certificate[] clientCertChain;
        SSLSocket sslSocket = (SSLSocket)this.socket;
        SSLSession sslSession = sslSocket.getSession();
        try {
            clientCertChain = (X509Certificate[])sslSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            clientCertChain = null;
        }
        return clientCertChain;
    }

    public String toString() {
        return "tcp://" + this.socket.getInetAddress() + ":" + this.socket.getPort() + "?enableSSL=true";
    }
}

