/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.tcp;

import com.bes.mq.transport.tcp.TimeStampStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TcpBufferedOutputStream
extends FilterOutputStream
implements TimeStampStream {
    private static final int BUFFER_SIZE = 8192;
    private byte[] buffer;
    private int bufferlen;
    private int count;
    private volatile long writeTimestamp = -1L;

    public TcpBufferedOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public TcpBufferedOutputStream(OutputStream out, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buffer = new byte[size];
        this.bufferlen = size;
    }

    public void write(int b) throws IOException {
        if (this.bufferlen - this.count < 1) {
            this.flush();
        }
        this.buffer[this.count++] = (byte)b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (b != null) {
            if (this.bufferlen - this.count < len) {
                this.flush();
            }
            if (this.buffer.length >= len) {
                System.arraycopy(b, off, this.buffer, this.count, len);
                this.count += len;
            } else {
                try {
                    this.writeTimestamp = System.currentTimeMillis();
                    this.out.write(b, off, len);
                    Object var5_4 = null;
                    this.writeTimestamp = -1L;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.writeTimestamp = -1L;
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        if (this.count > 0 && this.out != null) {
            try {
                this.writeTimestamp = System.currentTimeMillis();
                this.out.write(this.buffer, 0, this.count);
                Object var2_1 = null;
                this.writeTimestamp = -1L;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.writeTimestamp = -1L;
                throw throwable;
            }
            this.count = 0;
        }
    }

    public void close() throws IOException {
        super.close();
    }

    public boolean isWriting() {
        return this.writeTimestamp > 0L;
    }

    public long getWriteTimestamp() {
        return this.writeTimestamp;
    }
}

