/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.tcp;

import com.bes.mq.Service;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.thread.TaskRunnerFactory;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportLoggerFactory;
import com.bes.mq.transport.TransportThreadSupport;
import com.bes.mq.transport.tcp.QualityOfServiceUtils;
import com.bes.mq.transport.tcp.TcpBufferedInputStream;
import com.bes.mq.transport.tcp.TcpBufferedOutputStream;
import com.bes.mq.transport.tcp.TimeStampStream;
import com.bes.mq.util.InetAddressUtil;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.ServiceStopper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpTransport
extends TransportThreadSupport
implements Transport,
Service,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TcpTransport.class);
    protected final URI remoteLocation;
    protected final URI localLocation;
    protected final ProtocolFormat protocolFormat;
    protected int connectionTimeout = 30000;
    protected int soTimeout;
    protected int socketBufferSize = 65536;
    protected int ioBufferSize = 8192;
    protected boolean closeAsync = true;
    protected Socket socket;
    protected DataOutputStream dataOut;
    protected DataInputStream dataIn;
    protected TimeStampStream buffOut = null;
    protected int trafficClass = 0;
    private boolean trafficClassSet = false;
    protected boolean diffServChosen = false;
    protected boolean typeOfServiceChosen = false;
    protected boolean trace = false;
    protected String logWriterName = TransportLoggerFactory.defaultLogWriterName;
    protected boolean dynamicManagement = false;
    protected boolean startLogging = true;
    protected int jmxPort = 3100;
    protected boolean useLocalHost = false;
    protected int minmumProtocolFormatVersion;
    protected SocketFactory socketFactory;
    protected final AtomicReference<CountDownLatch> stoppedLatch = new AtomicReference();
    private Map<String, Object> socketOptions;
    private int soLinger = Integer.MIN_VALUE;
    private Boolean keepAlive;
    private Boolean tcpNoDelay;
    private Thread runnerThread;
    protected volatile int receiveCounter;

    public TcpTransport(ProtocolFormat protocolFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        this.protocolFormat = protocolFormat;
        this.socketFactory = socketFactory;
        try {
            this.socket = socketFactory.createSocket();
        }
        catch (SocketException e) {
            this.socket = null;
        }
        this.remoteLocation = remoteLocation;
        this.localLocation = localLocation;
        this.setDaemon(false);
    }

    public TcpTransport(ProtocolFormat protocolFormat, Socket socket) throws IOException {
        this.protocolFormat = protocolFormat;
        this.socket = socket;
        this.remoteLocation = null;
        this.localLocation = null;
        this.setDaemon(true);
    }

    @Override
    public void oneway(Object command) throws IOException {
        this.checkStarted();
        this.protocolFormat.marshal(command, this.dataOut);
        this.dataOut.flush();
    }

    public String toString() {
        return "" + (this.socket.isConnected() ? "tcp://" + this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getPort() + "@" + this.socket.getLocalPort() : (this.localLocation != null ? this.localLocation : this.remoteLocation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.trace("TCP consumer thread for " + this + " starting");
        this.runnerThread = Thread.currentThread();
        try {
            try {
                while (!this.isStopped()) {
                    this.doRun();
                }
                Object var6_1 = null;
                this.stoppedLatch.get().countDown();
                Thread.currentThread().interrupt();
            }
            catch (EOFException e) {
                try {
                    try {
                        this.socket.close();
                        LOG.warn("Closed socket {}", this.socket);
                    }
                    catch (IOException ex) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Caught exception closing socket " + this.socket + ". This exception will be ignored.", ex);
                        }
                        Object var4_10 = null;
                        this.stoppedLatch.get().countDown();
                        Thread.currentThread().interrupt();
                    }
                    Object var4_9 = null;
                    this.stoppedLatch.get().countDown();
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    Object var4_11 = null;
                    this.stoppedLatch.get().countDown();
                    Thread.currentThread().interrupt();
                    throw throwable;
                }
                Object var6_2 = null;
                this.stoppedLatch.get().countDown();
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                this.stoppedLatch.get().countDown();
                this.onException(e);
                Object var6_3 = null;
                this.stoppedLatch.get().countDown();
                Thread.currentThread().interrupt();
            }
            catch (Throwable e) {
                this.stoppedLatch.get().countDown();
                IOException ioe = new IOException("Unexpected error occured: " + e);
                ioe.initCause(e);
                this.onException(ioe);
                Object var6_4 = null;
                this.stoppedLatch.get().countDown();
                Thread.currentThread().interrupt();
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.stoppedLatch.get().countDown();
            Thread.currentThread().interrupt();
            throw throwable;
        }
    }

    protected void doRun() throws IOException {
        try {
            Object command = this.readCommand();
            this.doConsume(command);
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
    }

    protected Object readCommand() throws IOException {
        return this.protocolFormat.unmarshal(this.dataIn);
    }

    public String getDiffServ() {
        return Integer.toString(this.trafficClass);
    }

    public void setDiffServ(String diffServ) throws IllegalArgumentException {
        this.trafficClass = QualityOfServiceUtils.getDSCP(diffServ);
        this.diffServChosen = true;
    }

    public int getTypeOfService() {
        return this.trafficClass;
    }

    public void setTypeOfService(int typeOfService) {
        this.trafficClass = QualityOfServiceUtils.getToS(typeOfService);
        this.typeOfServiceChosen = true;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public String getLogWriterName() {
        return this.logWriterName;
    }

    public void setLogWriterName(String logFormat) {
        this.logWriterName = logFormat;
    }

    public boolean isDynamicManagement() {
        return this.dynamicManagement;
    }

    public void setDynamicManagement(boolean useJmx) {
        this.dynamicManagement = useJmx;
    }

    public boolean isStartLogging() {
        return this.startLogging;
    }

    public void setStartLogging(boolean startLogging) {
        this.startLogging = startLogging;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public void setJmxPort(int jmxPort) {
        this.jmxPort = jmxPort;
    }

    public int getMinmumProtocolFormatVersion() {
        return this.minmumProtocolFormatVersion;
    }

    public void setMinmumProtocolFormatVersion(int minmumProtocolFormatVersion) {
        this.minmumProtocolFormatVersion = minmumProtocolFormatVersion;
    }

    public boolean isUseLocalHost() {
        return this.useLocalHost;
    }

    public void setUseLocalHost(boolean useLocalHost) {
        this.useLocalHost = useLocalHost;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(Boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getIoBufferSize() {
        return this.ioBufferSize;
    }

    public void setIoBufferSize(int ioBufferSize) {
        this.ioBufferSize = ioBufferSize;
    }

    public boolean isCloseAsync() {
        return this.closeAsync;
    }

    public void setCloseAsync(boolean closeAsync) {
        this.closeAsync = closeAsync;
    }

    protected String resolveHostName(String host) throws UnknownHostException {
        String localName;
        if (this.isUseLocalHost() && (localName = InetAddressUtil.getLocalHostName()) != null && localName.equals(host)) {
            return "localhost";
        }
        return host;
    }

    protected void initialiseSocket(Socket sock) throws SocketException, IllegalArgumentException {
        if (this.socketOptions != null) {
            IntrospectionSupport.setProperties(this.socket, this.socketOptions);
        }
        try {
            sock.setReceiveBufferSize(this.socketBufferSize);
            sock.setSendBufferSize(this.socketBufferSize);
        }
        catch (SocketException se) {
            LOG.warn("Cannot set socket buffer size = " + this.socketBufferSize);
            LOG.debug("Cannot set socket buffer size. Reason: " + se, se);
        }
        sock.setSoTimeout(this.soTimeout);
        if (this.keepAlive != null) {
            sock.setKeepAlive(this.keepAlive);
        }
        if (this.soLinger > -1) {
            sock.setSoLinger(true, this.soLinger);
        } else if (this.soLinger == -1) {
            sock.setSoLinger(false, 0);
        }
        if (this.tcpNoDelay != null) {
            sock.setTcpNoDelay(this.tcpNoDelay);
        }
        if (!this.trafficClassSet) {
            this.trafficClassSet = this.setTrafficClass(sock);
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.connect();
        this.stoppedLatch.set(new CountDownLatch(1));
        super.doStart();
    }

    protected void connect() throws Exception {
        if (this.socket == null && this.socketFactory == null) {
            throw new IllegalStateException("Cannot connect if the socket or socketFactory have not been set");
        }
        InetSocketAddress localAddress = null;
        InetSocketAddress remoteAddress = null;
        if (this.localLocation != null) {
            localAddress = new InetSocketAddress(InetAddress.getByName(this.localLocation.getHost()), this.localLocation.getPort());
        }
        if (this.remoteLocation != null) {
            String host = this.resolveHostName(this.remoteLocation.getHost());
            remoteAddress = new InetSocketAddress(host, this.remoteLocation.getPort());
        }
        this.trafficClassSet = this.setTrafficClass(this.socket);
        if (this.socket != null) {
            if (localAddress != null) {
                this.socket.bind(localAddress);
            }
            if (remoteAddress != null) {
                if (this.connectionTimeout >= 0) {
                    this.socket.connect(remoteAddress, this.connectionTimeout);
                } else {
                    this.socket.connect(remoteAddress);
                }
            }
        } else {
            this.socket = localAddress != null ? this.socketFactory.createSocket(remoteAddress.getAddress(), remoteAddress.getPort(), localAddress.getAddress(), localAddress.getPort()) : this.socketFactory.createSocket(remoteAddress.getAddress(), remoteAddress.getPort());
        }
        this.initialiseSocket(this.socket);
        this.initializeStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        block10: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopping transport " + this);
            }
            if (this.socket != null) {
                if (this.closeAsync) {
                    final CountDownLatch latch = new CountDownLatch(1);
                    TaskRunnerFactory taskRunnerFactory = new TaskRunnerFactory();
                    taskRunnerFactory.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            LOG.trace("Closing socket {}", TcpTransport.this.socket);
                            try {
                                try {
                                    TcpTransport.this.socket.close();
                                    LOG.debug("Closed socket {}", TcpTransport.this.socket);
                                }
                                catch (IOException e) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("Caught exception closing socket " + TcpTransport.this.socket + ". This exception will be ignored.", e);
                                    }
                                    Object var3_2 = null;
                                    latch.countDown();
                                }
                                Object var3_1 = null;
                                latch.countDown();
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                latch.countDown();
                                throw throwable;
                            }
                        }
                    });
                    try {
                        try {
                            latch.await(1L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            Object var6_6 = null;
                            taskRunnerFactory.shutdownNow();
                        }
                        Object var6_5 = null;
                        taskRunnerFactory.shutdownNow();
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        taskRunnerFactory.shutdownNow();
                        throw throwable;
                    }
                } else {
                    LOG.trace("Closing socket {}", this.socket);
                    try {
                        this.socket.close();
                        LOG.debug("Closed socket {}", this.socket);
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block10;
                        LOG.debug("Caught exception closing socket " + this.socket + ". This exception will be ignored.", e);
                    }
                }
            }
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        CountDownLatch countDownLatch = this.stoppedLatch.get();
        if (countDownLatch != null && Thread.currentThread() != this.runnerThread) {
            try {
                countDownLatch.await(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
        }
    }

    protected void initializeStreams() throws Exception {
        TcpBufferedInputStream buffIn = new TcpBufferedInputStream(this.socket.getInputStream(), this.ioBufferSize){

            public int read() throws IOException {
                ++TcpTransport.this.receiveCounter;
                return super.read();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                ++TcpTransport.this.receiveCounter;
                return super.read(b, off, len);
            }

            public long skip(long n) throws IOException {
                ++TcpTransport.this.receiveCounter;
                return super.skip(n);
            }

            protected void fill() throws IOException {
                ++TcpTransport.this.receiveCounter;
                super.fill();
            }
        };
        this.dataIn = new DataInputStream(buffIn);
        TcpBufferedOutputStream outputStream = new TcpBufferedOutputStream(this.socket.getOutputStream(), this.ioBufferSize);
        this.dataOut = new DataOutputStream(outputStream);
        this.buffOut = outputStream;
    }

    protected void closeStreams() throws IOException {
        if (this.dataOut != null) {
            this.dataOut.close();
        }
        if (this.dataIn != null) {
            this.dataIn.close();
        }
    }

    public void setSocketOptions(Map<String, Object> socketOptions) {
        this.socketOptions = new HashMap<String, Object>(socketOptions);
    }

    @Override
    public String getRemoteAddress() {
        if (this.socket != null) {
            SocketAddress address = this.socket.getRemoteSocketAddress();
            if (address instanceof InetSocketAddress) {
                return "tcp://" + ((InetSocketAddress)address).getAddress().getHostAddress() + ":" + ((InetSocketAddress)address).getPort();
            }
            return "" + this.socket.getRemoteSocketAddress();
        }
        return null;
    }

    @Override
    public <T> T narrow(Class<T> target) {
        if (target == Socket.class) {
            return target.cast(this.socket);
        }
        if (target == TimeStampStream.class) {
            return target.cast(this.buffOut);
        }
        return super.narrow(target);
    }

    @Override
    public int getReceiveCounter() {
        return this.receiveCounter;
    }

    private boolean setTrafficClass(Socket sock) throws SocketException, IllegalArgumentException {
        if (sock == null || !this.diffServChosen && !this.typeOfServiceChosen) {
            return false;
        }
        if (this.diffServChosen && this.typeOfServiceChosen) {
            throw new IllegalArgumentException("Cannot set both the  Differentiated Services and Type of Services transport  options on the same connection.");
        }
        sock.setTrafficClass(this.trafficClass);
        int resultTrafficClass = sock.getTrafficClass();
        if (this.trafficClass != resultTrafficClass) {
            if (this.trafficClass >> 2 == resultTrafficClass >> 2 && (this.trafficClass & 3) != (resultTrafficClass & 3)) {
                LOG.warn("Attempted to set the Traffic Class to " + this.trafficClass + " but the result Traffic Class was " + resultTrafficClass + ". Please check that your system " + "allows you to set the ECN bits (the first two bits).");
            } else {
                LOG.warn("Attempted to set the Traffic Class to " + this.trafficClass + " but the result Traffic Class was " + resultTrafficClass + ". Please check that your system " + "supports java.net.setTrafficClass.");
            }
            return false;
        }
        this.diffServChosen = false;
        this.typeOfServiceChosen = false;
        return true;
    }

    public ProtocolFormat getProtocolFormat() {
        return this.protocolFormat;
    }
}

