/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.tcp;

import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.InactivityMonitor;
import com.bes.mq.transport.ProtocolFormatNegotiator;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFactory;
import com.bes.mq.transport.TransportLoggerFactory;
import com.bes.mq.transport.TransportServer;
import com.bes.mq.transport.tcp.TcpTransport;
import com.bes.mq.transport.tcp.TcpTransportServer;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.URISupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;

public class TcpTransportFactory
extends TransportFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TcpTransportFactory.class);

    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParameters(location));
            ServerSocketFactory serverSocketFactory = this.createServerSocketFactory();
            TcpTransportServer server = this.createTcpTransportServer(location, serverSocketFactory);
            server.setProtocolFormatFactory(this.createProtocolFormatFactory(options));
            IntrospectionSupport.setProperties(server, options);
            Map<String, Object> transportOptions = IntrospectionSupport.extractProperties(options, "transport.");
            server.setTransportOption(transportOptions);
            server.bind();
            return server;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new TcpTransportServer(this, location, serverSocketFactory);
    }

    public Transport compositeConfigure(Transport transport, ProtocolFormat format, Map options) {
        boolean useInactivityMonitor;
        TcpTransport tcpTransport = transport.narrow(TcpTransport.class);
        IntrospectionSupport.setProperties(tcpTransport, options);
        Map<String, Object> socketOptions = IntrospectionSupport.extractProperties(options, "socket.");
        tcpTransport.setSocketOptions(socketOptions);
        if (tcpTransport.isTrace()) {
            try {
                transport = TransportLoggerFactory.getInstance().createTransportLogger(transport, tcpTransport.getLogWriterName(), tcpTransport.isDynamicManagement(), tcpTransport.isStartLogging(), tcpTransport.getJmxPort());
            }
            catch (Throwable e) {
                LOG.error("Could not create TransportLogger object for: " + tcpTransport.getLogWriterName() + ", reason: " + e, e);
            }
        }
        if ((useInactivityMonitor = "true".equals(this.getOption(options, "useInactivityMonitor", "true"))) && this.isUseInactivityMonitor(transport)) {
            transport = this.createInactivityMonitor(transport, format);
            IntrospectionSupport.setProperties(transport, options);
        }
        if (format instanceof BESMPFormat) {
            transport = new ProtocolFormatNegotiator(transport, (BESMPFormat)format, tcpTransport.getMinmumProtocolFormatVersion());
        }
        return super.compositeConfigure(transport, format, options);
    }

    protected boolean isUseInactivityMonitor(Transport transport) {
        return true;
    }

    protected Transport createTransport(URI location, ProtocolFormat wf) throws UnknownHostException, IOException {
        URI localLocation;
        block3: {
            localLocation = null;
            String path = location.getPath();
            if (path != null && path.length() > 0) {
                int localPortIndex = path.indexOf(58);
                try {
                    Integer.parseInt(path.substring(localPortIndex + 1, path.length()));
                    String localString = location.getScheme() + ":/" + path;
                    localLocation = new URI(localString);
                }
                catch (Exception e) {
                    LOG.warn("Path isn't a valid local location for TcpTransport to use", (Object)e.getMessage());
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Failure detail", e);
                }
            }
        }
        SocketFactory socketFactory = this.createSocketFactory();
        return this.createTcpTransport(wf, socketFactory, location, localLocation);
    }

    protected TcpTransport createTcpTransport(ProtocolFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new TcpTransport(wf, socketFactory, location, localLocation);
    }

    protected ServerSocketFactory createServerSocketFactory() throws IOException {
        return ServerSocketFactory.getDefault();
    }

    protected SocketFactory createSocketFactory() throws IOException {
        return SocketFactory.getDefault();
    }

    protected Transport createInactivityMonitor(Transport transport, ProtocolFormat format) {
        return new InactivityMonitor(transport, format);
    }
}

