/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.tcp;

import com.bes.mq.Service;
import com.bes.mq.besmp.BESMPFormatFactory;
import com.bes.mq.command.BrokerInfo;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.protocolformat.ProtocolFormatFactory;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportLoggerFactory;
import com.bes.mq.transport.TransportServerThreadSupport;
import com.bes.mq.transport.tcp.ExceededMaximumConnectionsException;
import com.bes.mq.transport.tcp.TcpTransport;
import com.bes.mq.transport.tcp.TcpTransportFactory;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.InetAddressUtil;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.ServiceListener;
import com.bes.mq.util.ServiceStopper;
import com.bes.mq.util.ServiceSupport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.net.ServerSocketFactory;

public class TcpTransportServer
extends TransportServerThreadSupport
implements ServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(TcpTransportServer.class);
    protected ServerSocket serverSocket;
    protected int backlog = 5000;
    protected ProtocolFormatFactory protocolFormatFactory = new BESMPFormatFactory();
    protected final TcpTransportFactory transportFactory;
    protected long maxInactivityDuration = 30000L;
    protected long maxInactivityDurationInitalDelay = 10000L;
    protected int minmumProtocolFormatVersion;
    protected boolean useQueueForAccept = true;
    protected boolean trace = false;
    protected int soTimeout = 0;
    protected int socketBufferSize = 65536;
    protected int connectionTimeout = 30000;
    protected String logWriterName = TransportLoggerFactory.defaultLogWriterName;
    protected boolean dynamicManagement = false;
    protected boolean startLogging = true;
    protected final ServerSocketFactory serverSocketFactory;
    protected BlockingQueue<Socket> socketQueue = new LinkedBlockingQueue<Socket>();
    protected Thread socketHandlerThread;
    protected int maximumConnections = Integer.MAX_VALUE;
    protected int currentTransportCount = 0;

    public TcpTransportServer(TcpTransportFactory transportFactory, URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        super(location);
        this.transportFactory = transportFactory;
        this.serverSocketFactory = serverSocketFactory;
    }

    public void bind() throws IOException {
        URI bind = this.getBindLocation();
        String host = bind.getHost();
        host = host == null || host.length() == 0 ? "localhost" : host;
        InetAddress addr = InetAddress.getByName(host);
        try {
            this.serverSocket = this.serverSocketFactory.createServerSocket(bind.getPort(), this.backlog, addr);
            this.configureServerSocket(this.serverSocket);
        }
        catch (IOException e) {
            throw IOExceptionSupport.create("Failed to bind to server socket: " + bind + " due to: " + e, e);
        }
        try {
            this.setConnectURI(new URI(bind.getScheme(), bind.getUserInfo(), this.resolveHostName(this.serverSocket, addr), this.serverSocket.getLocalPort(), bind.getPath(), bind.getQuery(), bind.getFragment()));
        }
        catch (URISyntaxException e) {
            try {
                this.setConnectURI(new URI(bind.getScheme(), bind.getUserInfo(), addr.getHostAddress(), this.serverSocket.getLocalPort(), bind.getPath(), bind.getQuery(), bind.getFragment()));
            }
            catch (URISyntaxException e2) {
                throw IOExceptionSupport.create(e2);
            }
        }
    }

    private void configureServerSocket(ServerSocket socket) throws SocketException {
        socket.setSoTimeout(2000);
        if (this.transportOptions != null) {
            IntrospectionSupport.setProperties(socket, this.transportOptions);
        }
    }

    public ProtocolFormatFactory getProtocolFormatFactory() {
        return this.protocolFormatFactory;
    }

    public void setProtocolFormatFactory(ProtocolFormatFactory protocolFormatFactory) {
        this.protocolFormatFactory = protocolFormatFactory;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }

    public long getMaxInactivityDuration() {
        return this.maxInactivityDuration;
    }

    public void setMaxInactivityDuration(long maxInactivityDuration) {
        this.maxInactivityDuration = maxInactivityDuration;
    }

    public long getMaxInactivityDurationInitalDelay() {
        return this.maxInactivityDurationInitalDelay;
    }

    public void setMaxInactivityDurationInitalDelay(long maxInactivityDurationInitalDelay) {
        this.maxInactivityDurationInitalDelay = maxInactivityDurationInitalDelay;
    }

    public int getMinmumProtocolFormatVersion() {
        return this.minmumProtocolFormatVersion;
    }

    public void setMinmumProtocolFormatVersion(int minmumProtocolFormatVersion) {
        this.minmumProtocolFormatVersion = minmumProtocolFormatVersion;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public String getLogWriterName() {
        return this.logWriterName;
    }

    public void setLogWriterName(String logFormat) {
        this.logWriterName = logFormat;
    }

    public boolean isDynamicManagement() {
        return this.dynamicManagement;
    }

    public void setDynamicManagement(boolean useJmx) {
        this.dynamicManagement = useJmx;
    }

    public boolean isStartLogging() {
        return this.startLogging;
    }

    public void setStartLogging(boolean startLogging) {
        this.startLogging = startLogging;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public boolean isUseQueueForAccept() {
        return this.useQueueForAccept;
    }

    public void setUseQueueForAccept(boolean useQueueForAccept) {
        this.useQueueForAccept = useQueueForAccept;
    }

    public void run() {
        boolean isError = false;
        while (!this.isStopped() && !isError) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                if (socket == null) continue;
                if (this.isStopped() || this.getAcceptListener() == null) {
                    socket.close();
                    continue;
                }
                if (this.useQueueForAccept) {
                    this.socketQueue.put(socket);
                    continue;
                }
                this.handleSocket(socket);
            }
            catch (SocketTimeoutException ste) {
            }
            catch (Exception e) {
                isError = true;
                if (!this.isStopping()) {
                    this.onAcceptError(e);
                } else if (!this.isStopped()) {
                    LOG.warn("run()", e);
                    this.onAcceptError(e);
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException ioe) {
                        LOG.warn("Caught exception closing socket " + socket + ". This exception will be ignored.", ioe);
                    }
                }
                try {
                    this.setJoinOnStop(false);
                    this.connector.stop();
                }
                catch (Exception e1) {
                    LOG.info("Failed to stop connector " + this.connector.getName());
                    this.onAcceptError(e1);
                }
            }
        }
    }

    protected Transport createTransport(Socket socket, ProtocolFormat format) throws IOException {
        return new TcpTransport(format, socket);
    }

    public String toString() {
        return "" + this.getBindLocation();
    }

    protected String resolveHostName(ServerSocket socket, InetAddress bindAddress) throws UnknownHostException {
        String result = null;
        result = socket.isBound() ? (socket.getInetAddress().isAnyLocalAddress() ? InetAddressUtil.getLocalHostName() : socket.getInetAddress().getCanonicalHostName()) : bindAddress.getCanonicalHostName();
        return result;
    }

    protected void doStart() throws Exception {
        if (this.useQueueForAccept) {
            Runnable run = new Runnable(){

                public void run() {
                    block6: {
                        try {
                            while (!TcpTransportServer.this.isStopped() && !TcpTransportServer.this.isStopping()) {
                                Socket sock = TcpTransportServer.this.socketQueue.poll(1L, TimeUnit.SECONDS);
                                if (sock == null) continue;
                                TcpTransportServer.this.handleSocket(sock);
                            }
                            Socket socket = null;
                            while ((socket = (Socket)TcpTransportServer.this.socketQueue.poll()) != null) {
                                try {
                                    socket.close();
                                }
                                catch (Exception e) {
                                    LOG.warn("Caught exception closing socket " + socket + ". This exception will be ignored.", e);
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            LOG.info("socketQueue interuppted - stopping");
                            if (TcpTransportServer.this.isStopping()) break block6;
                            TcpTransportServer.this.onAcceptError(e);
                        }
                    }
                }
            };
            this.socketHandlerThread = new Thread(null, run, "BESMQ Transport Server Thread Handler: " + this.toString(), this.getStackSize());
            this.socketHandlerThread.setDaemon(true);
            this.socketHandlerThread.setPriority(8);
            this.socketHandlerThread.start();
        }
        super.doStart();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        super.doStop(stopper);
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)this.serverSocket.getLocalSocketAddress();
    }

    protected final void handleSocket(Socket socket) {
        block6: {
            try {
                if (this.currentTransportCount >= this.maximumConnections) {
                    throw new ExceededMaximumConnectionsException("Exceeded the maximum number of allowed client connections. See the 'maximumConnections' property on the TCP transport configuration URI in the BESMQ configuration file (e.g., besmq.xml)");
                }
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("maxInactivityDuration", this.maxInactivityDuration);
                options.put("maxInactivityDurationInitalDelay", this.maxInactivityDurationInitalDelay);
                options.put("minmumProtocolFormatVersion", this.minmumProtocolFormatVersion);
                options.put("trace", this.trace);
                options.put("soTimeout", this.soTimeout);
                options.put("socketBufferSize", this.socketBufferSize);
                options.put("connectionTimeout", this.connectionTimeout);
                options.put("logWriterName", this.logWriterName);
                options.put("dynamicManagement", this.dynamicManagement);
                options.put("startLogging", this.startLogging);
                options.putAll(this.transportOptions);
                ProtocolFormat format = this.protocolFormatFactory.createProtocolFormat();
                Transport transport = this.createTransport(socket, format);
                if (transport instanceof ServiceSupport) {
                    ((ServiceSupport)((Object)transport)).addServiceListener(this);
                }
                Transport configuredTransport = this.transportFactory.serverConfigure(transport, format, options);
                this.getAcceptListener().onAccept(configuredTransport);
            }
            catch (SocketTimeoutException ste) {
            }
            catch (Exception e) {
                if (!this.isStopping()) {
                    this.onAcceptError(e);
                }
                if (this.isStopped()) break block6;
                LOG.warn("run()", e);
                this.onAcceptError(e);
            }
        }
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaximumConnections() {
        return this.maximumConnections;
    }

    public void setMaximumConnections(int maximumConnections) {
        this.maximumConnections = maximumConnections;
    }

    public void started(Service service) {
        ++this.currentTransportCount;
    }

    public void stopped(Service service) {
        --this.currentTransportCount;
    }
}

