/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.udp;

import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.command.Command;
import com.bes.mq.transport.reliable.ReplayBuffer;
import com.bes.mq.transport.udp.CommandChannel;
import com.bes.mq.transport.udp.DatagramHeaderMarshaller;
import com.bes.mq.transport.udp.UdpTransport;
import com.bes.mq.util.IntSequenceGenerator;
import java.io.IOException;
import java.net.SocketAddress;

public abstract class CommandChannelSupport
implements CommandChannel {
    protected BESMPFormat protocolFormat;
    protected int datagramSize = 4096;
    protected SocketAddress targetAddress;
    protected SocketAddress replayAddress;
    protected final String name;
    protected final IntSequenceGenerator sequenceGenerator;
    protected DatagramHeaderMarshaller headerMarshaller;
    private ReplayBuffer replayBuffer;

    public CommandChannelSupport(UdpTransport transport, BESMPFormat protocolFormat, int datagramSize, SocketAddress targetAddress, DatagramHeaderMarshaller headerMarshaller) {
        this.protocolFormat = protocolFormat;
        this.datagramSize = datagramSize;
        this.targetAddress = targetAddress;
        this.headerMarshaller = headerMarshaller;
        this.name = transport.toString();
        this.sequenceGenerator = transport.getSequenceGenerator();
        this.replayAddress = targetAddress;
        if (this.sequenceGenerator == null) {
            throw new IllegalArgumentException("No sequenceGenerator on the given transport: " + transport);
        }
    }

    public void write(Command command) throws IOException {
        this.write(command, this.targetAddress);
    }

    public int getDatagramSize() {
        return this.datagramSize;
    }

    public void setDatagramSize(int datagramSize) {
        this.datagramSize = datagramSize;
    }

    public SocketAddress getTargetAddress() {
        return this.targetAddress;
    }

    public void setTargetAddress(SocketAddress targetAddress) {
        this.targetAddress = targetAddress;
    }

    public SocketAddress getReplayAddress() {
        return this.replayAddress;
    }

    public void setReplayAddress(SocketAddress replayAddress) {
        this.replayAddress = replayAddress;
    }

    public String toString() {
        return "CommandChannel#" + this.name;
    }

    public DatagramHeaderMarshaller getHeaderMarshaller() {
        return this.headerMarshaller;
    }

    public void setHeaderMarshaller(DatagramHeaderMarshaller headerMarshaller) {
        this.headerMarshaller = headerMarshaller;
    }

    public ReplayBuffer getReplayBuffer() {
        return this.replayBuffer;
    }

    public void setReplayBuffer(ReplayBuffer replayBuffer) {
        this.replayBuffer = replayBuffer;
    }
}

