/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.udp;

import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.besmp.BooleanStream;
import com.bes.mq.command.Command;
import com.bes.mq.command.Endpoint;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.reliable.ReplayBuffer;
import com.bes.mq.transport.udp.ByteBufferPool;
import com.bes.mq.transport.udp.CommandChannelSupport;
import com.bes.mq.transport.udp.DatagramHeaderMarshaller;
import com.bes.mq.transport.udp.UdpTransport;
import com.bes.mq.util.ByteArrayInputStream;
import com.bes.mq.util.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public class CommandDatagramChannel
extends CommandChannelSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CommandDatagramChannel.class);
    private DatagramChannel channel;
    private ByteBufferPool bufferPool;
    private Object readLock = new Object();
    private ByteBuffer readBuffer;
    private Object writeLock = new Object();
    private int defaultMarshalBufferSize = 65536;
    private volatile int receiveCounter;

    public CommandDatagramChannel(UdpTransport transport, BESMPFormat protocolFormat, int datagramSize, SocketAddress targetAddress, DatagramHeaderMarshaller headerMarshaller, DatagramChannel channel, ByteBufferPool bufferPool) {
        super(transport, protocolFormat, datagramSize, targetAddress, headerMarshaller);
        this.channel = channel;
        this.bufferPool = bufferPool;
    }

    public void start() throws Exception {
        this.bufferPool.setDefaultSize(this.datagramSize);
        this.bufferPool.start();
        this.readBuffer = this.bufferPool.borrowBuffer();
    }

    public void stop() throws Exception {
        this.bufferPool.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command read() throws IOException {
        Command answer = null;
        Endpoint from = null;
        Object object = this.readLock;
        synchronized (object) {
            SocketAddress address;
            do {
                this.readBuffer.clear();
                address = this.channel.receive(this.readBuffer);
                this.readBuffer.flip();
            } while (this.readBuffer.limit() == 0);
            ++this.receiveCounter;
            from = this.headerMarshaller.createEndpoint(this.readBuffer, address);
            int remaining = this.readBuffer.remaining();
            byte[] data = new byte[remaining];
            this.readBuffer.get(data);
            DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(data));
            answer = (Command)this.protocolFormat.unmarshal(dataIn);
        }
        if (answer != null) {
            answer.setFrom(from);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Channel: " + this.name + " received from: " + from + " about to process: " + answer);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Command command, SocketAddress address) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            ByteArrayOutputStream largeBuffer = new ByteArrayOutputStream(this.defaultMarshalBufferSize);
            this.protocolFormat.marshal(command, new DataOutputStream(largeBuffer));
            byte[] data = largeBuffer.toByteArray();
            int size = data.length;
            ByteBuffer writeBuffer = this.bufferPool.borrowBuffer();
            writeBuffer.clear();
            this.headerMarshaller.writeHeader(command, writeBuffer);
            if (size > writeBuffer.remaining()) {
                int offset = 0;
                boolean lastFragment = false;
                int length = data.length;
                int fragment = 0;
                while (!lastFragment) {
                    if (fragment > 0) {
                        writeBuffer = this.bufferPool.borrowBuffer();
                        writeBuffer.clear();
                        this.headerMarshaller.writeHeader(command, writeBuffer);
                    }
                    int chunkSize = writeBuffer.remaining();
                    BooleanStream bs = null;
                    if (this.protocolFormat.isTightEncodingEnabled()) {
                        bs = new BooleanStream();
                        bs.writeBoolean(true);
                    }
                    chunkSize -= 9;
                    chunkSize = bs != null ? (chunkSize -= bs.marshalledSize()) : --chunkSize;
                    if (!this.protocolFormat.isSizePrefixDisabled()) {
                        writeBuffer.putInt(chunkSize);
                        chunkSize -= 4;
                    }
                    boolean bl = lastFragment = offset + chunkSize >= length;
                    if (chunkSize + offset > length) {
                        chunkSize = length - offset;
                    }
                    if (lastFragment) {
                        writeBuffer.put((byte)51);
                    } else {
                        writeBuffer.put((byte)50);
                    }
                    if (bs != null) {
                        bs.marshal(writeBuffer);
                    }
                    int commandId = command.getCommandId();
                    if (fragment > 0) {
                        commandId = this.sequenceGenerator.getNextSequenceId();
                    }
                    writeBuffer.putInt(commandId);
                    if (bs == null) {
                        writeBuffer.put((byte)1);
                    }
                    writeBuffer.putInt(chunkSize);
                    writeBuffer.put(data, offset, chunkSize);
                    offset += chunkSize;
                    this.sendWriteBuffer(commandId, address, writeBuffer, false);
                    ++fragment;
                }
            } else {
                writeBuffer.put(data);
                this.sendWriteBuffer(command.getCommandId(), address, writeBuffer, false);
            }
        }
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public void setBufferPool(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    protected void sendWriteBuffer(int commandId, SocketAddress address, ByteBuffer writeBuffer, boolean redelivery) throws IOException {
        ReplayBuffer bufferCache = this.getReplayBuffer();
        if (bufferCache != null && !redelivery) {
            bufferCache.addBuffer(commandId, writeBuffer);
        }
        writeBuffer.flip();
        if (LOG.isDebugEnabled()) {
            String text = redelivery ? "REDELIVERING" : "sending";
            LOG.debug("Channel: " + this.name + " " + text + " datagram: " + commandId + " to: " + address);
        }
        this.channel.send(writeBuffer, address);
    }

    public void sendBuffer(int commandId, Object buffer) throws IOException {
        if (buffer != null) {
            ByteBuffer writeBuffer = (ByteBuffer)buffer;
            this.sendWriteBuffer(commandId, this.getReplayAddress(), writeBuffer, true);
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("Request for buffer: " + commandId + " is no longer present");
        }
    }

    public int getReceiveCounter() {
        return this.receiveCounter;
    }
}

