/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.udp;

import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.besmp.BooleanStream;
import com.bes.mq.command.Command;
import com.bes.mq.command.Endpoint;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.reliable.ReplayBuffer;
import com.bes.mq.transport.udp.CommandChannelSupport;
import com.bes.mq.transport.udp.DatagramHeaderMarshaller;
import com.bes.mq.transport.udp.UdpTransport;
import com.bes.mq.util.ByteArrayInputStream;
import com.bes.mq.util.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;

public class CommandDatagramSocket
extends CommandChannelSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CommandDatagramSocket.class);
    private DatagramSocket channel;
    private Object readLock = new Object();
    private Object writeLock = new Object();
    private volatile int receiveCounter;

    public CommandDatagramSocket(UdpTransport transport, BESMPFormat protocolFormat, int datagramSize, SocketAddress targetAddress, DatagramHeaderMarshaller headerMarshaller, DatagramSocket channel) {
        super(transport, protocolFormat, datagramSize, targetAddress, headerMarshaller);
        this.channel = channel;
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command read() throws IOException {
        Command answer = null;
        Endpoint from = null;
        Object object = this.readLock;
        synchronized (object) {
            DatagramPacket datagram = this.createDatagramPacket();
            this.channel.receive(datagram);
            ++this.receiveCounter;
            DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(datagram.getData(), 0, datagram.getLength()));
            from = this.headerMarshaller.createEndpoint(datagram, dataIn);
            answer = (Command)this.protocolFormat.unmarshal(dataIn);
        }
        if (answer != null) {
            answer.setFrom(from);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Channel: " + this.name + " about to process: " + answer);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Command command, SocketAddress address) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            ByteArrayOutputStream writeBuffer = this.createByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(writeBuffer);
            this.headerMarshaller.writeHeader(command, dataOut);
            int offset = writeBuffer.size();
            this.protocolFormat.marshal(command, dataOut);
            if (this.remaining(writeBuffer) >= 0) {
                this.sendWriteBuffer(address, writeBuffer, command.getCommandId());
            } else {
                byte[] data = writeBuffer.toByteArray();
                boolean lastFragment = false;
                int length = data.length;
                int fragment = 0;
                while (!lastFragment) {
                    writeBuffer = this.createByteArrayOutputStream();
                    this.headerMarshaller.writeHeader(command, dataOut);
                    int chunkSize = this.remaining(writeBuffer);
                    BooleanStream bs = null;
                    if (this.protocolFormat.isTightEncodingEnabled()) {
                        bs = new BooleanStream();
                        bs.writeBoolean(true);
                    }
                    chunkSize -= 9;
                    chunkSize = bs != null ? (chunkSize -= bs.marshalledSize()) : --chunkSize;
                    if (!this.protocolFormat.isSizePrefixDisabled()) {
                        dataOut.writeInt(chunkSize);
                        chunkSize -= 4;
                    }
                    boolean bl = lastFragment = offset + chunkSize >= length;
                    if (chunkSize + offset > length) {
                        chunkSize = length - offset;
                    }
                    if (lastFragment) {
                        dataOut.write(51);
                    } else {
                        dataOut.write(50);
                    }
                    if (bs != null) {
                        bs.marshal(dataOut);
                    }
                    int commandId = command.getCommandId();
                    if (fragment > 0) {
                        commandId = this.sequenceGenerator.getNextSequenceId();
                    }
                    dataOut.writeInt(commandId);
                    if (bs == null) {
                        dataOut.write(1);
                    }
                    dataOut.writeInt(chunkSize);
                    dataOut.write(data, offset, chunkSize);
                    offset += chunkSize;
                    this.sendWriteBuffer(address, writeBuffer, commandId);
                    ++fragment;
                }
            }
        }
    }

    public int getDatagramSize() {
        return this.datagramSize;
    }

    public void setDatagramSize(int datagramSize) {
        this.datagramSize = datagramSize;
    }

    protected void sendWriteBuffer(SocketAddress address, ByteArrayOutputStream writeBuffer, int commandId) throws IOException {
        byte[] data = writeBuffer.toByteArray();
        this.sendWriteBuffer(commandId, address, data, false);
    }

    protected void sendWriteBuffer(int commandId, SocketAddress address, byte[] data, boolean redelivery) throws IOException {
        ReplayBuffer bufferCache = this.getReplayBuffer();
        if (bufferCache != null && !redelivery) {
            bufferCache.addBuffer(commandId, data);
        }
        if (LOG.isDebugEnabled()) {
            String text = redelivery ? "REDELIVERING" : "sending";
            LOG.debug("Channel: " + this.name + " " + text + " datagram: " + commandId + " to: " + address);
        }
        DatagramPacket packet = new DatagramPacket(data, 0, data.length, address);
        this.channel.send(packet);
    }

    public void sendBuffer(int commandId, Object buffer) throws IOException {
        if (buffer != null) {
            byte[] data = (byte[])buffer;
            this.sendWriteBuffer(commandId, this.replayAddress, data, true);
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("Request for buffer: " + commandId + " is no longer present");
        }
    }

    protected DatagramPacket createDatagramPacket() {
        return new DatagramPacket(new byte[this.datagramSize], this.datagramSize);
    }

    protected int remaining(ByteArrayOutputStream buffer) {
        return this.datagramSize - buffer.size();
    }

    protected ByteArrayOutputStream createByteArrayOutputStream() {
        return new ByteArrayOutputStream(this.datagramSize);
    }

    public int getReceiveCounter() {
        return this.receiveCounter;
    }
}

