/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.udp;

import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.CommandJoiner;
import com.bes.mq.transport.InactivityMonitor;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFactory;
import com.bes.mq.transport.TransportLoggerFactory;
import com.bes.mq.transport.TransportServer;
import com.bes.mq.transport.reliable.DefaultReplayStrategy;
import com.bes.mq.transport.reliable.ExceptionIfDroppedReplayStrategy;
import com.bes.mq.transport.reliable.ReliableTransport;
import com.bes.mq.transport.reliable.ReplayStrategy;
import com.bes.mq.transport.reliable.Replayer;
import com.bes.mq.transport.tcp.TcpTransportFactory;
import com.bes.mq.transport.udp.ResponseRedirectInterceptor;
import com.bes.mq.transport.udp.UdpTransport;
import com.bes.mq.transport.udp.UdpTransportServer;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.URISupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class UdpTransportFactory
extends TransportFactory {
    private static final Logger log = LoggerFactory.getLogger(TcpTransportFactory.class);

    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParameters(location));
            if (options.containsKey("port")) {
                throw new IllegalArgumentException("The port property cannot be specified on a UDP server transport - please use the port in the URI syntax");
            }
            ProtocolFormat wf = this.createProtocolFormat(options);
            int port = location.getPort();
            BESMPFormat besMPFormat = this.asBESMPFormat(wf);
            UdpTransport transport = (UdpTransport)this.createTransport(location.getPort(), wf);
            Transport configuredTransport = this.configure(transport, wf, options, true);
            UdpTransportServer server = new UdpTransportServer(location, transport, configuredTransport, this.createReplayStrategy());
            return server;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public Transport configure(Transport transport, ProtocolFormat format, Map options) throws Exception {
        return this.configure(transport, format, options, false);
    }

    public Transport compositeConfigure(Transport transport, ProtocolFormat format, Map options) {
        IntrospectionSupport.setProperties(transport, options);
        UdpTransport udpTransport = (UdpTransport)transport;
        transport = new CommandJoiner(transport, this.asBESMPFormat(format));
        if (udpTransport.isTrace()) {
            try {
                transport = TransportLoggerFactory.getInstance().createTransportLogger(transport);
            }
            catch (Throwable e) {
                log.error("Could not create TransportLogger object for: " + TransportLoggerFactory.defaultLogWriterName + ", reason: " + e, e);
            }
        }
        transport = new InactivityMonitor(transport, format);
        if (format instanceof BESMPFormat) {
            transport = this.configureClientSideNegotiator(transport, format, udpTransport);
        }
        return transport;
    }

    protected Transport createTransport(URI location, ProtocolFormat wf) throws UnknownHostException, IOException {
        BESMPFormat protocolFormat = this.asBESMPFormat(wf);
        return new UdpTransport(protocolFormat, location);
    }

    protected Transport createTransport(int port, ProtocolFormat wf) throws UnknownHostException, IOException {
        BESMPFormat protocolFormat = this.asBESMPFormat(wf);
        return new UdpTransport(protocolFormat, port);
    }

    protected Transport configure(Transport transport, ProtocolFormat format, Map options, boolean acceptServer) throws Exception {
        IntrospectionSupport.setProperties(transport, options);
        UdpTransport udpTransport = (UdpTransport)transport;
        BESMPFormat besMPFormat = this.asBESMPFormat(format);
        if (udpTransport.isTrace()) {
            transport = TransportLoggerFactory.getInstance().createTransportLogger(transport);
        }
        transport = new InactivityMonitor(transport, format);
        if (!acceptServer && format instanceof BESMPFormat) {
            transport = this.configureClientSideNegotiator(transport, format, udpTransport);
        }
        if (acceptServer) {
            udpTransport.setReplayEnabled(false);
            transport = new CommandJoiner(transport, besMPFormat);
            return transport;
        }
        ReliableTransport reliableTransport = new ReliableTransport(transport, udpTransport);
        IntrospectionSupport.setProperties(reliableTransport, options);
        Replayer replayer = reliableTransport.getReplayer();
        reliableTransport.setReplayStrategy(this.createReplayStrategy(replayer));
        return new CommandJoiner(reliableTransport, besMPFormat);
    }

    protected ReplayStrategy createReplayStrategy(Replayer replayer) {
        if (replayer != null) {
            return new DefaultReplayStrategy(5);
        }
        return new ExceptionIfDroppedReplayStrategy(1);
    }

    protected ReplayStrategy createReplayStrategy() {
        return new DefaultReplayStrategy(5);
    }

    protected Transport configureClientSideNegotiator(Transport transport, ProtocolFormat format, UdpTransport udpTransport) {
        return new ResponseRedirectInterceptor(transport, udpTransport);
    }

    protected BESMPFormat asBESMPFormat(ProtocolFormat wf) {
        BESMPFormat answer = (BESMPFormat)wf;
        return answer;
    }
}

