/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.udp;

import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.command.BrokerInfo;
import com.bes.mq.command.Command;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.CommandJoiner;
import com.bes.mq.transport.InactivityMonitor;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportListener;
import com.bes.mq.transport.TransportServerSupport;
import com.bes.mq.transport.reliable.ReliableTransport;
import com.bes.mq.transport.reliable.ReplayStrategy;
import com.bes.mq.transport.udp.DatagramEndpoint;
import com.bes.mq.transport.udp.UdpTransport;
import com.bes.mq.util.ServiceStopper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class UdpTransportServer
extends TransportServerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(UdpTransportServer.class);
    private UdpTransport serverTransport;
    private ReplayStrategy replayStrategy;
    private Transport configuredTransport;
    private boolean usingProtocolFormatNegotiation;
    private Map<DatagramEndpoint, Transport> transports = new HashMap<DatagramEndpoint, Transport>();

    public UdpTransportServer(URI connectURI, UdpTransport serverTransport, Transport configuredTransport, ReplayStrategy replayStrategy) {
        super(connectURI);
        this.serverTransport = serverTransport;
        this.configuredTransport = configuredTransport;
        this.replayStrategy = replayStrategy;
    }

    public String toString() {
        return "UdpTransportServer@" + this.serverTransport;
    }

    public void run() {
    }

    public UdpTransport getServerTransport() {
        return this.serverTransport;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }

    protected void doStart() throws Exception {
        LOG.info("Starting " + this);
        this.configuredTransport.setTransportListener(new TransportListener(){

            public void onCommand(Object o) {
                Command command = (Command)o;
                UdpTransportServer.this.processInboundConnection(command);
            }

            public void onException(IOException error) {
                LOG.error("Caught: " + error, error);
            }

            public void transportInterupted() {
            }

            public void transportResumed() {
            }
        });
        this.configuredTransport.start();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        this.configuredTransport.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInboundConnection(Command command) {
        DatagramEndpoint endpoint = (DatagramEndpoint)command.getFrom();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received command on: " + this + " from address: " + endpoint + " command: " + command);
        }
        Transport transport = null;
        Map<DatagramEndpoint, Transport> map = this.transports;
        synchronized (map) {
            transport = this.transports.get(endpoint);
            if (transport == null) {
                if (this.usingProtocolFormatNegotiation && !command.isProtocolFormatInfo()) {
                    LOG.error("Received inbound server communication from: " + command.getFrom() + " expecting ProtocolFormatInfo but was command: " + command);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Creating a new UDP server connection");
                    }
                    try {
                        transport = this.createTransport(command, endpoint);
                        transport = this.configureTransport(transport);
                        this.transports.put(endpoint, transport);
                    }
                    catch (IOException e) {
                        LOG.error("Caught: " + e, e);
                        this.getAcceptListener().onAcceptError(e);
                    }
                }
            } else {
                LOG.warn("Discarding duplicate command to server from: " + endpoint + " command: " + command);
            }
        }
    }

    protected Transport configureTransport(Transport transport) {
        transport = new InactivityMonitor(transport, this.serverTransport.getProtocolFormat());
        this.getAcceptListener().onAccept(transport);
        return transport;
    }

    protected Transport createTransport(final Command command, DatagramEndpoint endpoint) throws IOException {
        if (endpoint == null) {
            throw new IOException("No endpoint available for command: " + command);
        }
        SocketAddress address = endpoint.getAddress();
        BESMPFormat connectionProtocolFormat = this.serverTransport.getProtocolFormat().copy();
        UdpTransport transport = new UdpTransport(connectionProtocolFormat, address);
        final ReliableTransport reliableTransport = new ReliableTransport((Transport)transport, transport);
        reliableTransport.getReplayer();
        reliableTransport.setReplayStrategy(this.replayStrategy);
        return new CommandJoiner(reliableTransport, connectionProtocolFormat){

            public void start() throws Exception {
                super.start();
                reliableTransport.onCommand(command);
            }
        };
    }

    public InetSocketAddress getSocketAddress() {
        return this.serverTransport.getLocalSocketAddress();
    }
}

