/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.vm;

import com.bes.mq.broker.TransportConnector;
import com.bes.mq.command.BrokerInfo;
import com.bes.mq.transport.MutexTransport;
import com.bes.mq.transport.ResponseCorrelator;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportAcceptListener;
import com.bes.mq.transport.TransportServer;
import com.bes.mq.transport.vm.VMTransport;
import com.bes.mq.transport.vm.VMTransportFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;

public class VMTransportServer
implements TransportServer {
    private TransportAcceptListener acceptListener;
    private final URI location;
    private boolean disposed;
    private final AtomicInteger connectionCount = new AtomicInteger(0);
    private final boolean disposeOnDisconnect;

    public VMTransportServer(URI location, boolean disposeOnDisconnect) {
        this.location = location;
        this.disposeOnDisconnect = disposeOnDisconnect;
    }

    public String toString() {
        return "VMTransportServer(" + this.location + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VMTransport connect() throws IOException {
        TransportAcceptListener al;
        VMTransportServer vMTransportServer = this;
        synchronized (vMTransportServer) {
            if (this.disposed) {
                throw new IOException("Server has been disposed.");
            }
            al = this.acceptListener;
        }
        if (al == null) {
            throw new IOException("Server TransportAcceptListener is null.");
        }
        this.connectionCount.incrementAndGet();
        VMTransport client = new VMTransport(this.location){

            public void stop() throws Exception {
                if (!this.disposed.get()) {
                    super.stop();
                    if (VMTransportServer.this.connectionCount.decrementAndGet() == 0 && VMTransportServer.this.disposeOnDisconnect) {
                        VMTransportServer.this.stop();
                    }
                }
            }
        };
        VMTransport server = new VMTransport(this.location);
        client.setPeer(server);
        server.setPeer(client);
        al.onAccept(VMTransportServer.configure(server));
        return client;
    }

    public static Transport configure(Transport transport) {
        transport = new MutexTransport(transport);
        transport = new ResponseCorrelator(transport);
        return transport;
    }

    public synchronized void setAcceptListener(TransportAcceptListener acceptListener) {
        this.acceptListener = acceptListener;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
        VMTransportFactory.stopped(this);
    }

    public URI getConnectURI() {
        return this.location;
    }

    public URI getBindURI() {
        return this.location;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }

    public InetSocketAddress getSocketAddress() {
        return null;
    }

    public int getConnectionCount() {
        return this.connectionCount.intValue();
    }

    public void setConnector(TransportConnector connector) {
    }
}

