/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.ws;

import com.bes.mq.command.Command;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.TransportSupport;
import com.bes.mq.transport.stomp.ProtocolConverter;
import com.bes.mq.transport.stomp.StompFrame;
import com.bes.mq.transport.stomp.StompInactivityMonitor;
import com.bes.mq.transport.stomp.StompProtocolFormat;
import com.bes.mq.transport.stomp.StompTransport;
import com.bes.mq.util.ByteSequence;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.ServiceStopper;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jetty.websocket.WebSocket;

class StompSocket
extends TransportSupport
implements WebSocket.OnTextMessage,
StompTransport {
    private static final Logger LOG = LoggerFactory.getLogger(StompSocket.class);
    WebSocket.Connection outbound;
    ProtocolConverter protocolConverter = new ProtocolConverter(this, null);
    StompProtocolFormat protocolFormat = new StompProtocolFormat();
    private final CountDownLatch socketTransportStarted = new CountDownLatch(1);

    StompSocket() {
    }

    public void onOpen(WebSocket.Connection connection) {
        this.outbound = connection;
    }

    public void onClose(int closeCode, String message) {
    }

    public void onMessage(String data) {
        if (!this.transportStartedAtLeastOnce()) {
            LOG.debug("Waiting for StompSocket to be properly started...");
            try {
                this.socketTransportStarted.await();
            }
            catch (InterruptedException e) {
                LOG.warn("While waiting for StompSocket to be properly started, we got interrupted!! Should be okay, but you could see race conditions...");
            }
        }
        try {
            this.protocolConverter.onStompCommand((StompFrame)this.protocolFormat.unmarshal(new ByteSequence(data.getBytes("UTF-8"))));
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    private boolean transportStartedAtLeastOnce() {
        return this.socketTransportStarted.getCount() == 0L;
    }

    @Override
    protected void doStart() throws Exception {
        this.socketTransportStarted.countDown();
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
    }

    @Override
    public int getReceiveCounter() {
        return 0;
    }

    @Override
    public String getRemoteAddress() {
        return "StompSocket_" + this.hashCode();
    }

    @Override
    public void oneway(Object command) throws IOException {
        try {
            this.protocolConverter.onBESMQCommand((Command)command);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    @Override
    public void sendToBESMQ(Command command) {
        this.doConsume(command);
    }

    @Override
    public void sendToStomp(StompFrame command) throws IOException {
        this.outbound.sendMessage(command.format());
    }

    @Override
    public StompInactivityMonitor getInactivityMonitor() {
        return null;
    }

    @Override
    public StompProtocolFormat getProtocolFormat() {
        return this.protocolFormat;
    }
}

