/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.ws;

import com.bes.mq.command.BrokerInfo;
import com.bes.mq.transport.SocketConnectorFactory;
import com.bes.mq.transport.WebTransportServerSupport;
import com.bes.mq.transport.ws.StompServlet;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.ServiceStopper;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class WSTransportServer
extends WebTransportServerSupport {
    public WSTransportServer(URI location) {
        super(location);
        this.bindAddress = location;
        this.socketConnectorFactory = new SocketConnectorFactory();
    }

    @Override
    protected void doStart() throws Exception {
        this.server = new Server();
        if (this.connector == null) {
            this.connector = this.socketConnectorFactory.createConnector();
        }
        URI bind = this.getBindLocation();
        this.bind();
        ServletContextHandler contextHandler = new ServletContextHandler((HandlerContainer)this.server, "/", 0);
        ServletHolder holder = new ServletHolder();
        Map<String, Object> webSocketOptions = IntrospectionSupport.extractProperties(this.transportOptions, "websocket.");
        for (Map.Entry<String, Object> webSocketEntry : webSocketOptions.entrySet()) {
            Object value = webSocketEntry.getValue();
            if (value == null) continue;
            holder.setInitParameter(webSocketEntry.getKey(), value.toString());
        }
        holder.setServlet((Servlet)new StompServlet());
        contextHandler.addServlet(holder, "/");
        contextHandler.setAttribute("acceptListener", (Object)this.getAcceptListener());
        this.server.start();
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        Server temp = this.server;
        this.server = null;
        if (temp != null) {
            temp.stop();
        }
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return null;
    }

    @Override
    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }

    protected void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Override
    public void setTransportOption(Map<String, Object> transportOptions) {
        Map<String, Object> socketOptions = IntrospectionSupport.extractProperties(transportOptions, "transport.");
        this.socketConnectorFactory.setTransportOptions(socketOptions);
        super.setTransportOption(transportOptions);
    }
}

