/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.transport.xstream;

import com.bes.mq.com.thoughtworks.xstream.XStream;
import com.bes.mq.command.Command;
import com.bes.mq.command.MarshallAware;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.transport.util.TextProtocolFormat;
import java.io.IOException;
import java.io.Reader;

public class XStreamProtocolFormat
extends TextProtocolFormat {
    private XStream xStream;
    private int version;

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    public ProtocolFormat copy() {
        return new XStreamProtocolFormat();
    }

    @Override
    public Object unmarshalText(String text) {
        return (Command)this.getXStream().fromXML(text);
    }

    @Override
    public Object unmarshalText(Reader reader) {
        return (Command)this.getXStream().fromXML(reader);
    }

    @Override
    public String marshalText(Object command) throws IOException {
        MessageDispatch dispatch;
        if (command instanceof MarshallAware) {
            ((MarshallAware)command).beforeMarshall(this);
        } else if (command instanceof MessageDispatch && (dispatch = (MessageDispatch)command) != null && dispatch.getMessage() != null) {
            dispatch.getMessage().beforeMarshall(this);
        }
        return this.getXStream().toXML(command);
    }

    public boolean canProcessProtocolFormatVersion(int version) {
        return true;
    }

    public int getCurrentProtocolFormatVersion() {
        return 1;
    }

    public XStream getXStream() {
        if (this.xStream == null) {
            this.xStream = this.createXStream();
            this.xStream.setClassLoader(this.getClass().getClassLoader());
        }
        return this.xStream;
    }

    public void setXStream(XStream xStream) {
        this.xStream = xStream;
    }

    protected XStream createXStream() {
        return new XStream();
    }
}

